/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.my_home.web.action;

import com.atlassian.jira.my_home.MyJiraHomeUpdateService;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeUpdateException;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateMyJiraHome
extends JiraWebActionSupport {
    static final String MY_JIRA_HOME = "/secure/MyJiraHome.jspa";
    private final MyJiraHomeUpdateService myJiraHomeUpdateService;
    private String target;

    public UpdateMyJiraHome(@Nonnull MyJiraHomeUpdateService myJiraHomeUpdateService) {
        this.myJiraHomeUpdateService = myJiraHomeUpdateService;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ApplicationUser authenticatedUser = this.getLoggedInUser();
        if (authenticatedUser != null) {
            this.updateMyHome(authenticatedUser);
        }
        return this.getRedirect(MY_JIRA_HOME);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable String target) {
        this.target = target;
    }

    private void updateMyHome(@Nonnull ApplicationUser user) {
        try {
            this.myJiraHomeUpdateService.updateHome(user, Strings.nullToEmpty((String)this.target));
        }
        catch (MyJiraHomeUpdateException e) {
            this.addErrorMessage(e.getMessage());
        }
    }
}

