/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.my_home;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.my_home.MyJiraHomeStorage;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeChangedEvent;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeUpdateException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MyJiraHomeStorageImpl
implements MyJiraHomeStorage {
    private static final String MY_JIRA_HOME_PREFERENCE_KEY = "my.jira.home";
    private final UserPreferencesManager userPreferencesManager;
    private final EventPublisher eventPublisher;

    public MyJiraHomeStorageImpl(@Nonnull UserPreferencesManager userPreferencesManager, @Nonnull EventPublisher eventPublisher) {
        this.userPreferencesManager = userPreferencesManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Nonnull
    public String load(@Nonnull ApplicationUser user) {
        Preferences preferences = this.getPreferences(user);
        if (preferences == null) {
            return "";
        }
        return this.doLoad(preferences);
    }

    @Override
    public void store(@Nonnull ApplicationUser user, @Nonnull String home) {
        Preferences preferences = this.getPreferences(user);
        if (preferences == null) {
            throw new MyJiraHomeUpdateException("failed to load user's preferences: " + user);
        }
        String currentHome = this.doLoad(preferences);
        if (Strings.isNullOrEmpty((String)home.trim())) {
            this.doRemove(preferences);
        } else {
            this.doUpdate(preferences, home);
        }
        this.eventPublisher.publish((Object)new MyJiraHomeChangedEvent(user, currentHome, home));
    }

    @Nullable
    private Preferences getPreferences(@Nullable ApplicationUser user) {
        return this.userPreferencesManager.getExtendedPreferences(user);
    }

    private String doLoad(@Nonnull Preferences preferences) {
        return Strings.nullToEmpty((String)preferences.getString(MY_JIRA_HOME_PREFERENCE_KEY));
    }

    private void doRemove(@Nonnull Preferences preferences) {
        try {
            preferences.remove(MY_JIRA_HOME_PREFERENCE_KEY);
        }
        catch (AtlassianCoreException e) {
            throw new MyJiraHomeUpdateException((Throwable)e);
        }
    }

    private void doUpdate(@Nonnull Preferences preferences, @Nonnull String home) {
        try {
            preferences.setString(MY_JIRA_HOME_PREFERENCE_KEY, home);
        }
        catch (AtlassianCoreException e) {
            throw new MyJiraHomeUpdateException((Throwable)e);
        }
    }
}

