/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tzdetect;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.tzdetect.BannerPreferences;
import com.atlassian.jira.tzdetect.RegionInfoBean;
import com.atlassian.jira.tzdetect.TimeZoneInfoBean;
import com.atlassian.jira.tzdetect.TimeZoneListBean;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/zones")
@Consumes(value={"application/json"})
public class TimeZoneListResource {
    private final TimeZoneService timeZoneService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final BannerPreferences bannerPreferences;

    public TimeZoneListResource(TimeZoneService timeZoneService, JiraAuthenticationContext jiraAuthenticationContext, BannerPreferences bannerPreferences) {
        this.timeZoneService = timeZoneService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.bannerPreferences = bannerPreferences;
    }

    @GET
    @Produces(value={"application/json"})
    public TimeZoneListBean listZones(@QueryParam(value="janOffset") int janOffset, @QueryParam(value="julyOffset") int julyOffset) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        ArrayList matchingZones = Lists.newArrayList();
        List allZones = this.timeZoneService.getTimeZoneInfos((JiraServiceContext)serviceContext);
        List allRegions = this.timeZoneService.getTimeZoneRegions((JiraServiceContext)serviceContext);
        HashSet regionKeys = Sets.newHashSet();
        ArrayList matchingRegions = Lists.newArrayListWithCapacity((int)allRegions.size());
        for (TimeZoneInfo timeZoneInfo : allZones) {
            TimeZone timeZone = timeZoneInfo.toTimeZone();
            if (this.bannerPreferences.getJanOffset(timeZone) != janOffset || this.bannerPreferences.getJulyOffset(timeZone) != julyOffset) continue;
            matchingZones.add(new TimeZoneInfoBean(timeZoneInfo));
            regionKeys.add(timeZoneInfo.getRegionKey());
        }
        for (RegionInfo regionInfo : allRegions) {
            if (!regionKeys.contains(regionInfo.getKey())) continue;
            matchingRegions.add(new RegionInfoBean(regionInfo));
        }
        TimeZoneListBean timeZoneListBean = new TimeZoneListBean(matchingZones, matchingRegions);
        return timeZoneListBean;
    }
}

