/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tzdetect;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BannerPreferences {
    @Autowired
    @ComponentImport
    private TimeZoneService timeZoneService;
    @Autowired
    @ComponentImport
    private JiraAuthenticationContext jiraAuthenticationContext;

    private int getDateOffset(TimeZone timeZone, int month, int day) {
        DateTime now = new DateTime();
        DateTime dateTime = new DateTime(now.getYear(), month, day, 12, 0);
        return timeZone.getOffset(dateTime.toDate().getTime());
    }

    public int getJanOffset(TimeZone timeZone) {
        return this.getDateOffset(timeZone, 1, 1);
    }

    public int getJulyOffset(TimeZone timeZone) {
        return this.getDateOffset(timeZone, 7, 1);
    }

    public void setUserTimeZonePreference(String id) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user != null) {
            JiraServiceContextImpl context = new JiraServiceContextImpl(user);
            this.timeZoneService.setUserDefaultTimeZone(id, (JiraServiceContext)context);
        }
    }

    public TimeZoneInfo getUserTimeZonePreference() {
        return this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser()));
    }
}

