/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.remotejira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalIdFactoryImpl;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraIssue;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraIssueBuilder;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraRestService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONTokener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RemoteJiraRestServiceImpl
implements RemoteJiraRestService {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String REST_BASE_URL = "rest/api/";
    private static final String ISSUE_RESOURCE = "issue";
    private static final String REMOTE_LINK_RESOURCE = "remotelink";
    private final InternalHostApplication internalHostApplication;
    private final RequestFactory<Request<?, Response>> requestFactory;

    @Autowired
    public RemoteJiraRestServiceImpl(@ComponentImport InternalHostApplication internalHostApplication, @ComponentImport RequestFactory<Request<?, Response>> requestFactory) {
        this.internalHostApplication = internalHostApplication;
        this.requestFactory = requestFactory;
    }

    @Override
    public RemoteResponse<RemoteJiraIssue> getIssue(ApplicationLink applicationLink, String issueIdOrKey, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestServiceImpl.createGetIssueRequest(applicationLink, issueIdOrKey, restVersion);
        ResponseToIssueConverter jsonConverter = new ResponseToIssueConverter(applicationLink.getDisplayUrl().toASCIIString(), restVersion);
        return (RemoteResponse)request.execute(new RestResponseHandler<RemoteJiraIssue>(jsonConverter, restVersion));
    }

    @Override
    public RemoteResponse<RemoteJiraIssue> getIssue(String baseUri, String issueIdOrKey, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException, ResponseException {
        Request<?, Response> request = this.createGetIssueRequest(baseUri, issueIdOrKey, restVersion);
        ResponseToIssueConverter jsonConverter = new ResponseToIssueConverter(baseUri, restVersion);
        return (RemoteResponse)request.executeAndReturn(new RestResponseHandler<RemoteJiraIssue>(jsonConverter, restVersion));
    }

    @Override
    public RemoteResponse<JSONObject> createRemoteIssueLink(ApplicationLink applicationLink, String remoteIssueKey, Issue issue, String relationship, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestServiceImpl.createCreateRemoteIssueLinkRequest(applicationLink, remoteIssueKey, restVersion);
        request.setRequestBody(this.getJsonForCreateRemoteIssueLink(issue, relationship), JSON_CONTENT_TYPE);
        return (RemoteResponse)request.execute(new RestResponseHandler<JSONObject>(new ResponseToJsonConverter(), restVersion));
    }

    @Override
    public RemoteResponse<String> requestResource(ApplicationLink applicationLink, String resourcePath, Map<String, String> params, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestServiceImpl.createGetRestResourceRequest(applicationLink, resourcePath, params, restVersion);
        return (RemoteResponse)request.execute(new RestResponseHandler<String>(new ResponseToStringConverter(), restVersion));
    }

    @Override
    public RemoteResponse<String> requestURL(ApplicationLink applicationLink, String url, Map<String, String> params) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestServiceImpl.createGetURLRequest(applicationLink, url, params);
        return (RemoteResponse)request.execute(new RestResponseHandler<String>(new ResponseToStringConverter(), null));
    }

    private String getJsonForCreateRemoteIssueLink(Issue issue, String relationship) {
        try {
            JSONObject json = new JSONObject();
            String globalId = RemoteJiraGlobalIdFactoryImpl.encode(this.internalHostApplication.getId(), issue.getId());
            json.put("globalId", (Object)globalId);
            JSONObject application = new JSONObject();
            application.put("type", (Object)"com.atlassian.jira");
            application.put("name", (Object)this.internalHostApplication.getName());
            json.put("application", (Object)application);
            json.put("relationship", (Object)relationship);
            JSONObject object = new JSONObject();
            object.put("url", (Object)RemoteJiraRestServiceImpl.buildIssueUrl(this.internalHostApplication.getBaseUrl().toASCIIString(), issue.getKey()));
            object.put("title", (Object)issue.getKey());
            json.put("object", (Object)object);
            return json.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildIssueUrl(String baseUri, String issueKey) {
        return new UrlBuilder(baseUri).addPathUnsafe("browse").addPath(issueKey).asUrlString();
    }

    private static ApplicationLinkRequest createGetIssueRequest(ApplicationLink applicationLink, String issueKey, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException {
        String restUrl = new UrlBuilder(REST_BASE_URL).addPathUnsafe(restVersion.toString()).addPathUnsafe(ISSUE_RESOURCE).addPath(issueKey).asUrlString();
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        return requestFactory.createRequest(Request.MethodType.GET, restUrl);
    }

    private Request<?, Response> createGetIssueRequest(String baseUri, String issueKey, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException {
        String restUrl = new UrlBuilder(baseUri).addPathUnsafe(REST_BASE_URL).addPathUnsafe(restVersion.toString()).addPathUnsafe(ISSUE_RESOURCE).addPath(issueKey).asUrlString();
        return this.requestFactory.createRequest(Request.MethodType.GET, restUrl);
    }

    private static ApplicationLinkRequest createGetRestResourceRequest(ApplicationLink applicationLink, String resourcePath, Map<String, String> params, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException {
        UrlBuilder urlBuilder = new UrlBuilder(REST_BASE_URL).addPathUnsafe(restVersion.toString()).addPathUnsafe(resourcePath);
        return RemoteJiraRestServiceImpl.createGetURLRequest(applicationLink, urlBuilder.asUrlString(), params);
    }

    private static ApplicationLinkRequest createGetURLRequest(ApplicationLink applicationLink, String url, Map<String, String> params) throws CredentialsRequiredException {
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                urlBuilder.addParameter(param.getKey(), param.getValue());
            }
        }
        String restUrl = urlBuilder.asUrlString();
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        return requestFactory.createRequest(Request.MethodType.GET, restUrl);
    }

    private static ApplicationLinkRequest createCreateRemoteIssueLinkRequest(ApplicationLink applicationLink, String issueKey, RemoteJiraRestService.RestVersion restVersion) throws CredentialsRequiredException {
        UrlBuilder urlBuilder = new UrlBuilder(REST_BASE_URL).addPathUnsafe(restVersion.toString()).addPathUnsafe(ISSUE_RESOURCE).addPath(issueKey).addPathUnsafe(REMOTE_LINK_RESOURCE);
        String restUrl = urlBuilder.asUrlString();
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        return requestFactory.createRequest(Request.MethodType.POST, restUrl);
    }

    private static ErrorCollection convertResponseToErrorCollection(JSONObject json, RemoteJiraRestService.RestVersion restVersion) throws JSONException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        switch (restVersion) {
            case VERSION_2_0alpha1: 
            case VERSION_2: {
                JSONArray errorMessages = json.getJSONArray("errorMessages");
                for (int i = 0; i < errorMessages.length(); ++i) {
                    errors.addErrorMessage(errorMessages.getString(i));
                }
                JSONObject errorsMap = json.getJSONObject("errors");
                Iterator keys = errorsMap.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    errors.addError(key, errorsMap.getString(key));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported REST version: " + (Object)((Object)restVersion));
            }
        }
        return errors;
    }

    private static String appendNameAndDescription(JSONObject json) throws JSONException {
        String name = json.getString("name");
        String description = json.optString("description");
        if (StringUtils.isBlank((String)description)) {
            return name;
        }
        return name + " - " + description;
    }

    private static String getResponseBodyAsString(Response response) throws ResponseException {
        InputStream responseBodyStream = response.getResponseBodyAsStream();
        String charset = RemoteJiraRestServiceImpl.getCharset(response);
        try {
            return IOUtil.toString((InputStream)responseBodyStream, (String)charset);
        }
        catch (IOException exception) {
            throw new ResponseException("Failed to read remote JIRA issue", (Throwable)exception);
        }
    }

    private static String getCharset(Response response) {
        ContentType contentType;
        String DEFAULT = "UTF-8";
        String contentTypeString = response.getHeader("Content-Type");
        if (contentTypeString == null) {
            return "UTF-8";
        }
        try {
            contentType = new ContentType(contentTypeString);
        }
        catch (ParseException exception) {
            return "UTF-8";
        }
        return StringUtils.defaultIfEmpty((String)contentType.getParameter("charset"), (String)"UTF-8");
    }

    private static class ResponseToIssueConverter
    implements ResponseConverter<RemoteJiraIssue> {
        private final String baseUri;
        private final RemoteJiraRestService.RestVersion restVersion;

        private ResponseToIssueConverter(String baseUri, RemoteJiraRestService.RestVersion restVersion) {
            this.baseUri = baseUri;
            this.restVersion = restVersion;
        }

        @Override
        public RemoteJiraIssue convert(String responseString) {
            RemoteJiraIssueBuilder builder = new RemoteJiraIssueBuilder();
            try {
                JSONObject json = new JSONObject(new JSONTokener(responseString));
                JSONObject fields = json.getJSONObject("fields");
                switch (this.restVersion) {
                    case VERSION_2: {
                        builder.id(json.getLong("id"));
                        builder.summary(fields.getString("summary"));
                        String key = json.getString("key");
                        builder.key(key);
                        builder.browseUrl(RemoteJiraRestServiceImpl.buildIssueUrl(this.baseUri, key));
                        JSONObject issueType = fields.getJSONObject("issuetype");
                        builder.iconUrl(issueType.getString("iconUrl"));
                        builder.iconTitle(RemoteJiraRestServiceImpl.appendNameAndDescription(issueType));
                        JSONObject status = fields.getJSONObject("status");
                        builder.statusIconUrl(status.getString("iconUrl"));
                        builder.statusName(status.getString("name"));
                        builder.statusDescription(status.optString("description"));
                        builder.statusIconTitle(RemoteJiraRestServiceImpl.appendNameAndDescription(status));
                        if (status.has("statusCategory")) {
                            JSONObject statusCategory = status.getJSONObject("statusCategory");
                            builder.statusCategoryKey(statusCategory.getString("key"));
                            builder.statusCategoryColorName(statusCategory.getString("colorName"));
                        }
                        builder.resolved(!fields.isNull("resolution"));
                        break;
                    }
                    case VERSION_2_0alpha1: {
                        throw new UnsupportedOperationException("Currently only REST API version 2 is supported");
                    }
                }
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse remote JIRA response", e);
            }
            return builder.build();
        }
    }

    private static class ResponseToStringConverter
    implements ResponseConverter<String> {
        private ResponseToStringConverter() {
        }

        @Override
        public String convert(String responseString) {
            return responseString;
        }
    }

    private static class ResponseToJsonConverter
    implements ResponseConverter<JSONObject> {
        private ResponseToJsonConverter() {
        }

        @Override
        public JSONObject convert(String responseString) {
            try {
                return new JSONObject(new JSONTokener(responseString));
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse remote JIRA response", e);
            }
        }
    }

    private static interface ResponseConverter<T> {
        public T convert(String var1);
    }

    private static class RestResponseHandler<T>
    implements ApplicationLinkResponseHandler<RemoteResponse<T>> {
        private final ResponseConverter<T> responseConverter;
        private final RemoteJiraRestService.RestVersion restVersion;

        public RestResponseHandler(ResponseConverter<T> responseConverter, RemoteJiraRestService.RestVersion restVersion) {
            this.responseConverter = responseConverter;
            this.restVersion = restVersion;
        }

        public RemoteResponse<T> credentialsRequired(Response response) throws ResponseException {
            return RemoteResponse.credentialsRequired((Response)response);
        }

        public RemoteResponse<T> handle(Response response) throws ResponseException {
            String responseString = RemoteJiraRestServiceImpl.getResponseBodyAsString(response);
            Object entity = null;
            ErrorCollection errors = null;
            if (!StringUtils.isBlank((String)responseString)) {
                if (response.isSuccessful()) {
                    entity = this.responseConverter.convert(responseString);
                } else if (this.restVersion != null) {
                    try {
                        JSONObject json = new JSONObject(new JSONTokener(responseString));
                        errors = RemoteJiraRestServiceImpl.convertResponseToErrorCollection(json, this.restVersion);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
            return new RemoteResponse(entity, errors, response);
        }
    }
}

