/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.remotejira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalId;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalIdFactory;
import com.atlassian.jira.plugin.viewissue.issuelink.GlobalIdFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteJiraGlobalIdFactoryImpl
implements RemoteJiraGlobalIdFactory {
    private static final String APP_ID_KEY = "appId";
    private static final String ISSUE_ID_KEY = "issueId";
    private static final List<String> KEYS = ImmutableList.of((Object)"appId", (Object)"issueId");
    private final ApplicationLinkService applicationLinkService;

    @Autowired
    public RemoteJiraGlobalIdFactoryImpl(@ComponentImport ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public static String encode(RemoteJiraGlobalId globalId) {
        return RemoteJiraGlobalIdFactoryImpl.encode(globalId.getApplicationLink().getId(), globalId.getRemoteIssueId());
    }

    public static String encode(ApplicationId applicationId, Long issueId) {
        Map values = MapBuilder.newBuilder().add((Object)APP_ID_KEY, (Object)applicationId.get()).add((Object)ISSUE_ID_KEY, (Object)issueId.toString()).toMap();
        return GlobalIdFactory.encode(KEYS, (Map)values);
    }

    @Override
    public RemoteJiraGlobalId decode(String globalId) {
        Long issueId;
        Map values = GlobalIdFactory.decode((String)globalId, KEYS);
        String appId = (String)values.get(APP_ID_KEY);
        ApplicationLink appLink = this.getApplicationLink(appId);
        if (appLink == null) {
            throw new IllegalArgumentException("No Application Link found for the given Application Id: " + appId);
        }
        String issueIdString = (String)values.get(ISSUE_ID_KEY);
        try {
            issueId = Long.parseLong(issueIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid Issue Id. Expecting intege, found: " + issueIdString, e);
        }
        return new RemoteJiraGlobalId(appLink, issueId);
    }

    private ApplicationLink getApplicationLink(String appId) {
        for (ApplicationLink appLink : this.applicationLinkService.getApplicationLinks(JiraApplicationType.class)) {
            if (!appLink.getId().get().equals(appId)) continue;
            return appLink;
        }
        return null;
    }
}

