/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.remotejira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkDisplayHelper;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalId;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalIdFactoryImpl;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraIssue;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraRestService;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraRestServiceImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.issue.AbstractIssueLinkAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkJiraIssue
extends AbstractIssueLinkAction {
    private static final RemoteJiraRestService.RestVersion REST_VERSION = RemoteJiraRestService.RestVersion.VERSION_2;
    private static final String DEFAULT_CREATE_RECIPROCAL_KEY = "jira.issuelink.createreciprocal";
    private Collection<String> linkDescs;
    private Collection<ApplicationLink> jiraAppLinks;
    private String linkDesc = "";
    private String jiraAppId = "";
    private Collection<String> issueKeys;
    private boolean createReciprocal;
    private IssueLinkType issueLinkType;
    private ApplicationLink jiraAppLink;
    private Collection<MutableIssue> validatedIssues;
    private Collection<RemoteIssueLinkService.CreateValidationResult> validationResults;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkService issueLinkService;
    private final IssueLinkDisplayHelper issueLinkDisplayHelper;
    private final UserHistoryManager userHistoryManager;
    private final UserPropertyManager userPropertyManager;
    private final ApplicationLinkService applicationLinkService;
    private final RemoteJiraRestService remoteJiraRestService;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;
    private final InternalHostApplication internalHostApplication;

    @Autowired
    public LinkJiraIssue(@ComponentImport SubTaskManager subTaskManager, @ComponentImport FieldScreenRendererFactory fieldScreenRendererFactory, @ComponentImport FieldManager fieldManager, @ComponentImport ProjectRoleManager projectRoleManager, @ComponentImport CommentService commentService, @ComponentImport UserHistoryManager userHistoryManager, @ComponentImport UserPropertyManager userPropertyManager, @ComponentImport IssueLinkService issueLinkService, @ComponentImport UserUtil userUtil, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, @ComponentImport RemoteIssueLinkService remoteIssueLinkService, @ComponentImport EventPublisher eventPublisher, @ComponentImport ApplicationLinkService applicationLinkService, RemoteJiraRestService remoteJiraRestService, @ComponentImport IssueManager issueManager, @ComponentImport IssueLinkManager issueLinkManager, @ComponentImport InternalHostApplication internalHostApplication, @ComponentImport IssueEventManager issueEventManager, @ComponentImport IssueEventBundleFactory issueEventBundleFactory) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil, remoteIssueLinkService, eventPublisher, issueEventManager, issueEventBundleFactory);
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkService = issueLinkService;
        this.userHistoryManager = userHistoryManager;
        this.userPropertyManager = userPropertyManager;
        this.issueManager = issueManager;
        this.issueLinkManager = issueLinkManager;
        this.issueLinkDisplayHelper = new IssueLinkDisplayHelper(userHistoryManager, this.getLoggedInUser());
        this.applicationLinkService = applicationLinkService;
        this.remoteJiraRestService = remoteJiraRestService;
        this.internalHostApplication = internalHostApplication;
    }

    public boolean isValidToView() {
        return super.isValidToView() && !this.getLinkDescs().isEmpty();
    }

    protected void doValidation() {
        super.doValidation();
        if (!this.getLinkDescs().contains(this.linkDesc)) {
            this.addError("linkDesc", this.getText("linkjiraissue.error.link.desc.invalid"));
        } else if (this.getIssueLinkType().isSystemLinkType()) {
            this.addError("linkDesc", this.getText("linkjiraissue.error.systemlink"));
        }
        if (this.issueKeys == null || this.issueKeys.isEmpty()) {
            this.addError("issueKeys", this.getText("linkjiraissue.error.issuekey.required"));
        }
        if (StringUtils.isBlank((String)this.jiraAppId)) {
            this.validateLocalLink();
        } else {
            this.validateRemoteLink();
        }
    }

    private void validateLocalLink() {
        if (!this.hasAnyErrors()) {
            this.validatedIssues = new ArrayList<MutableIssue>(this.issueKeys.size());
            for (String key : this.issueKeys) {
                MutableIssue issue = this.issueManager.getIssueObject(key);
                if (issue == null) {
                    this.addError("issueKeys", this.getText("linkissue.error.notexist", key));
                    continue;
                }
                if (key.equals(this.getIssue().getString("key"))) {
                    this.addError("issueKeys", this.getText("linkissue.error.selflink"));
                    continue;
                }
                this.validatedIssues.add(issue);
            }
        }
    }

    private void validateRemoteLink() {
        if (this.getJiraAppLink() == null) {
            this.addError("jiraAppId", this.getText("linkjiraissue.error.jira.app.invalid"));
        }
        if (!this.hasAnyErrors()) {
            this.validationResults = new ArrayList<RemoteIssueLinkService.CreateValidationResult>(this.issueKeys.size());
            for (String issueKey : this.issueKeys) {
                RemoteJiraIssue remoteJiraIssue = this.queryRemoteIssue(this.getJiraAppLink(), issueKey);
                if (remoteJiraIssue == null) continue;
                this.validationResults.add(this.validateCreateRemote(remoteJiraIssue));
            }
        }
    }

    public String doDefault() throws Exception {
        String result = super.doDefault();
        if (!"error".equals(result)) {
            this.populateCommentFields();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    protected String doExecute() {
        boolean createLocalLink;
        boolean bl = createLocalLink = this.validatedIssues != null;
        if (createLocalLink) {
            this.createLocalLinks();
        } else {
            this.createRemoteLinks();
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, this.getLoggedInUser(), String.valueOf(this.getIssueLinkType().getId()), this.linkDesc);
        try {
            if (!createLocalLink) {
                Map<String, ErrorCollection> failedIssueKeys;
                this.setDefaultCreateReciprocal(this.createReciprocal);
                if (this.createReciprocal && !(failedIssueKeys = this.createReciprocalLinks(this.issueKeys)).isEmpty()) {
                    String string = this.returnCompleteWithReciprocalError(failedIssueKeys);
                    return string;
                }
            }
        }
        finally {
            this.createAndDispatchComment();
        }
        return this.returnComplete(this.getRedirectUrl());
    }

    private void createLocalLinks() {
        IssueLinkType linkType = this.getIssueLinkType();
        for (MutableIssue issue : this.validatedIssues) {
            this.createLocalLink(linkType, issue);
        }
    }

    private void createLocalLink(IssueLinkType linkType, MutableIssue destinationIssue) {
        try {
            if (this.linkDesc.equals(linkType.getOutward())) {
                this.issueLinkManager.createIssueLink(this.getIssue().getLong("id"), destinationIssue.getId(), linkType.getId(), null, this.getLoggedInUser());
            } else {
                this.issueLinkManager.createIssueLink(destinationIssue.getId(), this.getIssue().getLong("id"), linkType.getId(), null, this.getLoggedInUser());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred creating link: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.issues.an.error.occured", e));
        }
    }

    private void createRemoteLinks() {
        for (RemoteIssueLinkService.CreateValidationResult validationResult : this.validationResults) {
            RemoteIssueLinkService.RemoteIssueLinkResult result = this.createLink(validationResult);
            if (result.isValid()) continue;
            this.mapErrors(result.getErrorCollection());
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    private Map<String, ErrorCollection> createReciprocalLinks(Collection<String> remoteIssueKeys) {
        HashMap<String, ErrorCollection> failedIssueKeys = new HashMap<String, ErrorCollection>(remoteIssueKeys.size());
        for (String remoteIssueKey : remoteIssueKeys) {
            try {
                RemoteResponse<JSONObject> response = this.remoteJiraRestService.createRemoteIssueLink(this.getJiraAppLink(), remoteIssueKey, this.getIssueObject(), this.getReciprocalLinkDesc(), REST_VERSION);
                if (response.isSuccessful()) continue;
                failedIssueKeys.put(remoteIssueKey, response.getErrors());
            }
            catch (CredentialsRequiredException e) {
                failedIssueKeys.put(remoteIssueKey, null);
            }
            catch (ResponseException e) {
                failedIssueKeys.put(remoteIssueKey, null);
            }
        }
        return failedIssueKeys;
    }

    private String returnCompleteWithReciprocalError(Map<String, ErrorCollection> errorsByIssueKey) {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, ErrorCollection> entry : errorsByIssueKey.entrySet()) {
            String remoteIssueKey = entry.getKey();
            ErrorCollection errors = entry.getValue();
            if (msg.length() > 0) {
                msg.append("<br>");
            }
            String hyperlink = "<a id='remoteIssue' href='" + this.getRemoteIssueUrl(TextUtils.htmlEncode((String)remoteIssueKey)) + "'>" + TextUtils.htmlEncode((String)remoteIssueKey) + "</a>";
            if (errors != null && errors.getErrorMessages() != null && !errors.getErrorMessages().isEmpty()) {
                String remoteErrorMsg = TextUtils.htmlEncode((String)((String)errors.getErrorMessages().iterator().next()));
                msg.append(this.getText("linkjiraissue.error.reciprocal.desc.with.reason", hyperlink, remoteErrorMsg));
                continue;
            }
            msg.append(this.getText("linkjiraissue.error.reciprocal.desc", hyperlink));
        }
        return this.returnMsgToUser(this.getRedirectUrl(), msg.toString(), JiraWebActionSupport.MessageType.WARNING, true, "#linkingmodule .mod-content");
    }

    private RemoteJiraIssue queryRemoteIssue(ApplicationLink applicationLink, String issueKey) {
        try {
            RemoteResponse<RemoteJiraIssue> response = this.remoteJiraRestService.getIssue(applicationLink, issueKey, REST_VERSION);
            if (response.isSuccessful()) {
                return (RemoteJiraIssue)response.getEntity();
            }
            switch (response.getStatusCode()) {
                case 404: {
                    if (response.hasErrors()) {
                        this.addErrorMessage(this.getText("linkjiraissue.error.remoteissue.notfound", TextUtils.htmlEncode((String)issueKey)));
                        break;
                    }
                    this.addErrorMessage(this.getText("linkjiraissue.error.remoteinstance.oldversion", TextUtils.htmlEncode((String)issueKey)));
                    break;
                }
                case 403: {
                    this.addErrorMessage(this.getText("linkjiraissue.error.remoteissue.forbidden", TextUtils.htmlEncode((String)issueKey)));
                    break;
                }
                case 401: {
                    this.handleCredentialsRequired();
                    break;
                }
                default: {
                    this.addErrorMessage(this.getText("linkjiraissue.error.invalid.response", TextUtils.htmlEncode((String)issueKey)));
                    this.log.error((Object)("Invalid response from remote JIRA server: " + response.getStatusCode() + ": " + response.getStatusText()));
                    break;
                }
            }
        }
        catch (CredentialsRequiredException e) {
            this.handleCredentialsRequired();
        }
        catch (ResponseException e) {
            this.addErrorMessage(this.getText("linkjiraissue.error.invalid.response", TextUtils.htmlEncode((String)issueKey)));
            this.log.error((Object)("Invalid response from remote JIRA server: " + e.getMessage()));
        }
        return null;
    }

    private RemoteIssueLinkService.CreateValidationResult validateCreateRemote(RemoteJiraIssue remoteJiraIssue) {
        String globalId = RemoteJiraGlobalIdFactoryImpl.encode(new RemoteJiraGlobalId(this.getJiraAppLink(), remoteJiraIssue.getId()));
        RemoteIssueLink remoteIssueLink = new RemoteIssueLinkBuilder().url(remoteJiraIssue.getBrowseUrl()).title(remoteJiraIssue.getKey()).globalId(globalId).issueId(this.id).relationship(this.linkDesc).applicationName(this.getJiraAppLink().getName()).applicationType(RemoteIssueLink.APPLICATION_TYPE_JIRA).build();
        RemoteIssueLinkService.CreateValidationResult validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
        if (!validationResult.isValid()) {
            this.mapErrors(validationResult.getErrorCollection());
            this.addErrorCollection(validationResult.getErrorCollection());
        }
        return validationResult;
    }

    private void mapErrors(ErrorCollection errorCollection) {
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            errorCollection.addErrorMessage((String)entry.getValue());
        }
    }

    private String getReciprocalLinkDesc() {
        IssueLinkType linkType = this.getIssueLinkType();
        if (linkType == null) {
            return null;
        }
        if (this.linkDesc.equals(linkType.getOutward())) {
            return linkType.getInward();
        }
        return linkType.getOutward();
    }

    private IssueLinkType getIssueLinkType() {
        if (this.issueLinkType == null) {
            for (IssueLinkType linkType : this.issueLinkTypeManager.getIssueLinkTypes()) {
                if (!this.linkDesc.equals(linkType.getOutward()) && !this.linkDesc.equals(linkType.getInward())) continue;
                this.issueLinkType = linkType;
                break;
            }
        }
        return this.issueLinkType;
    }

    public String getLinkDesc() {
        return this.linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Collection<String> getLinkDescs() {
        if (this.linkDescs == null) {
            this.linkDescs = this.issueLinkDisplayHelper.getSortedIssueLinkTypes(this.issueLinkService.getIssueLinkTypes());
        }
        return this.linkDescs;
    }

    public String getLastUsedLinkType() {
        return this.issueLinkDisplayHelper.getLastUsedLinkType();
    }

    public InternalHostApplication getInternalHostApplication() {
        return this.internalHostApplication;
    }

    public ApplicationLink getJiraAppLink() {
        if (this.jiraAppLink == null) {
            for (ApplicationLink appLink : this.getJiraAppLinks()) {
                if (!appLink.getId().get().equals(this.jiraAppId)) continue;
                this.jiraAppLink = appLink;
            }
        }
        return this.jiraAppLink;
    }

    public String getJiraAppId() {
        return this.jiraAppId;
    }

    public void setJiraAppId(String jiraAppId) {
        this.jiraAppId = jiraAppId;
    }

    public Collection<ApplicationLink> getJiraAppLinks() {
        if (this.jiraAppLinks == null) {
            Iterable iterable = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
            this.jiraAppLinks = new ArrayList<ApplicationLink>();
            for (ApplicationLink appLink : iterable) {
                this.jiraAppLinks.add(appLink);
            }
        }
        return this.jiraAppLinks;
    }

    public String[] getIssueKeys() {
        if (this.issueKeys == null) {
            this.issueKeys = Sets.newHashSet();
        }
        return this.issueKeys.toArray(new String[0]);
    }

    public String getRemoteIssueUrl(String issueKey) {
        return RemoteJiraRestServiceImpl.buildIssueUrl(this.getJiraAppLink().getDisplayUrl().toASCIIString(), issueKey);
    }

    public void setIssueKeys(String[] issueKeys) {
        this.issueKeys = Sets.newHashSet((Object[])issueKeys);
    }

    public boolean isCreateReciprocal() {
        return this.createReciprocal;
    }

    public void setCreateReciprocal(boolean createReciprocal) {
        this.createReciprocal = createReciprocal;
    }

    public boolean getDefaultCreateReciprocal() {
        ApplicationUser user = this.getLoggedInUser();
        if (user == null) {
            return false;
        }
        String value = this.userPropertyManager.getPropertySet(user).getString(DEFAULT_CREATE_RECIPROCAL_KEY);
        if (StringUtils.isBlank((String)value)) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    private void setDefaultCreateReciprocal(boolean createReciprocal) {
        ApplicationUser user = this.getLoggedInUser();
        if (user != null) {
            this.userPropertyManager.getPropertySet(user).setString(DEFAULT_CREATE_RECIPROCAL_KEY, String.valueOf(createReciprocal));
        }
    }
}

