/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.remotejira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.remotejira.JiraRemoteIssueLinkDecoratingService;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalId;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraGlobalIdFactoryImpl;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraIssue;
import com.atlassian.jira.plugin.link.remotejira.RemoteJiraRestService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrlSwapper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class JiraRemoteIssueLinkDecoratingServiceImpl
implements JiraRemoteIssueLinkDecoratingService {
    private final RemoteJiraRestService remoteJiraRestService;
    private final RemoteJiraGlobalIdFactoryImpl remoteJiraGlobalIdFactory;
    private final JiraAuthenticationContext authContext;

    @Autowired
    public JiraRemoteIssueLinkDecoratingServiceImpl(RemoteJiraRestService remoteJiraRestService, RemoteJiraGlobalIdFactoryImpl remoteJiraGlobalIdFactory, @ComponentImport JiraAuthenticationContext authContext) {
        this.remoteJiraRestService = remoteJiraRestService;
        this.remoteJiraGlobalIdFactory = remoteJiraGlobalIdFactory;
        this.authContext = authContext;
    }

    @Override
    public RemoteIssueLink decorate(RemoteIssueLink remoteIssueLink) throws CredentialsRequiredException, IOException, PermissionException {
        if (!RemoteIssueLink.APPLICATION_TYPE_JIRA.equals(remoteIssueLink.getApplicationType())) {
            throw new IllegalArgumentException("Remote link is not to JIRA");
        }
        RemoteJiraGlobalId remoteJiraGlobalId = this.remoteJiraGlobalIdFactory.decode(remoteIssueLink.getGlobalId());
        ApplicationLink jiraAppLink = remoteJiraGlobalId.getApplicationLink();
        String remoteIssueID = String.valueOf(remoteJiraGlobalId.getRemoteIssueId());
        try {
            RemoteResponse<RemoteJiraIssue> response = this.remoteJiraRestService.getIssue(jiraAppLink, remoteIssueID, RemoteJiraRestService.RestVersion.VERSION_2);
            return this.handleJiraResponse(response, remoteIssueLink, jiraAppLink);
        }
        catch (ResponseException exception) {
            throw new IOException("Failed to load JIRA issue from remote server", exception);
        }
    }

    private RemoteIssueLink handleJiraResponse(RemoteResponse<RemoteJiraIssue> response, RemoteIssueLink remoteIssueLink, ApplicationLink jiraAppLink) throws ResponseException, CredentialsRequiredException, PermissionException {
        if (!response.isSuccessful()) {
            switch (response.getStatusCode()) {
                case 401: {
                    if (this.authContext.getUser() != null) {
                        throw new CredentialsRequiredException((AuthorisationURIGenerator)jiraAppLink.createAuthenticatedRequestFactory(), "Token expired");
                    }
                    throw new PermissionException();
                }
                case 403: {
                    throw new PermissionException();
                }
            }
            throw new ResponseException(response.getStatusText());
        }
        RemoteJiraIssue remoteJiraIssue = (RemoteJiraIssue)response.getEntity();
        return new RemoteIssueLink(remoteIssueLink.getId(), remoteIssueLink.getIssueId(), remoteIssueLink.getGlobalId(), remoteJiraIssue.getKey(), remoteJiraIssue.getSummary(), remoteJiraIssue.getBrowseUrl(), BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)remoteJiraIssue.getIconUrl(), (ApplicationLink)jiraAppLink), remoteJiraIssue.getIconTitle(), remoteIssueLink.getRelationship(), Boolean.valueOf(remoteJiraIssue.isResolved()), BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)remoteJiraIssue.getStatusIconUrl(), (ApplicationLink)jiraAppLink), remoteJiraIssue.getStatusIconTitle(), BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)remoteIssueLink.getStatusIconLink(), (ApplicationLink)jiraAppLink), remoteIssueLink.getApplicationType(), jiraAppLink.getName(), remoteJiraIssue.getStatusName(), remoteJiraIssue.getStatusDescription(), remoteJiraIssue.getStatusCategoryKey(), remoteJiraIssue.getStatusCategoryColorName());
    }
}

