/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.userprofile;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.userprofile.AbstractUserProfilePanel;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DetailsUserProfilePanel
extends AbstractUserProfilePanel {
    private final EmailFormatter emailFormatter;
    private final GroupPermissionChecker groupPermissionChecker;
    private final PermissionManager permissionManager;
    private final CrowdService crowdService;
    private final UserPropertyManager userPropertyManager;
    private final WebResourceManager webResourceManager;
    private final AvatarManager avatarManager;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FeatureManager featureManager;
    private final ApplicationProperties applicationProperties;

    public DetailsUserProfilePanel(JiraAuthenticationContext jiraAuthenticationContext, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, PermissionManager permissionManager, CrowdService crowdService, UserPropertyManager userPropertyManager, WebResourceManager webResourceManager, AvatarManager avatarManager, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory, AvatarService avatarService, FeatureManager featureManager, ApplicationProperties applicationProperties) {
        super(jiraAuthenticationContext);
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
        this.userPropertyManager = userPropertyManager;
        this.webResourceManager = webResourceManager;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.featureManager = featureManager;
        this.applicationProperties = applicationProperties;
    }

    public Map<String, Object> getContextMap(Map<String, Object> initialContext) {
        List<String> groups;
        ApplicationUser profileUser = (ApplicationUser)initialContext.get("profileUser");
        ApplicationUser currentUser = (ApplicationUser)initialContext.get("currentUser");
        this.webResourceManager.requireResource("jira.webresources:avatar-picker");
        Map<String, Object> params = this.createVelocityParams(profileUser, currentUser);
        params.put("context", new Context(profileUser, currentUser));
        params.put("panelId", this.getId());
        boolean canEditAvatar = this.avatarService.canSetCustomUserAvatar(currentUser, profileUser.getName());
        boolean currentUserIsProfileUser = currentUser.equals((Object)profileUser);
        params.put("user", profileUser);
        params.put("defaultAvatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        PropertySet propertySet = this.userPropertyManager.getPropertySet(profileUser);
        if (propertySet.exists("user.avatar.id")) {
            params.put("avatarId", propertySet.getLong("user.avatar.id"));
        } else {
            params.put("avatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        }
        boolean hasCustomUserAvatar = this.avatarService.hasCustomUserAvatar(currentUser, profileUser.getName());
        if (!this.avatarService.isGravatarEnabled() && canEditAvatar && currentUserIsProfileUser && !hasCustomUserAvatar) {
            params.put("avatarSrc", String.format("%s/images/icons/ico_add_avatar.png", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl()));
        } else {
            params.put("avatarSrc", this.avatarService.getAvatarAbsoluteURL(currentUser, profileUser.getName(), Avatar.Size.LARGE));
        }
        params.put("displayEdit", this.displayEdit(profileUser, currentUser));
        boolean isAdmin = this.isAdmin(currentUser);
        params.put("isAdmin", isAdmin);
        params.put("displayChangePassword", this.displayChangePassword(profileUser, currentUser));
        params.put("displayRememberMe", this.displayRememberMe(profileUser, currentUser));
        if (this.emailFormatter.emailVisible(currentUser)) {
            params.put("email", this.emailFormatter.formatEmailAsLink(profileUser.getEmailAddress(), currentUser));
        }
        if (!(groups = this.getGroups(profileUser, currentUser)).isEmpty()) {
            params.put("groups", groups);
        }
        params.put("userProperties", this.getUserProperties(profileUser, isAdmin));
        return params;
    }

    public String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    @Override
    public String getId() {
        return "details-profile-fragment";
    }

    private boolean displayEdit(ApplicationUser profileUser, ApplicationUser currentUser) {
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            return false;
        }
        if (this.userManager.canUpdateUser(profileUser)) {
            return profileUser.equals((Object)currentUser);
        }
        return false;
    }

    private boolean displayChangePassword(ApplicationUser profileUser, ApplicationUser currentUser) {
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            return false;
        }
        if (this.userManager.canUpdateUserPassword(profileUser)) {
            return profileUser.equals((Object)currentUser);
        }
        return false;
    }

    private Object displayRememberMe(ApplicationUser profileUser, ApplicationUser currentUser) {
        return profileUser.equals((Object)currentUser) && !this.featureManager.isEnabled(CoreFeatures.ON_DEMAND);
    }

    private List<String> getGroups(ApplicationUser profileUser, ApplicationUser currentUser) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : this.getGroupsForUser(profileUser.getName())) {
            if (!this.groupPermissionChecker.hasViewGroupPermission(group, currentUser)) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean isAdmin(ApplicationUser currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private Map<String, String> getUserProperties(ApplicationUser profileUser, boolean isAdmin) {
        HashMap<String, String> userProperties = new HashMap<String, String>();
        if (profileUser != null && isAdmin) {
            PropertySet userPropertySet = this.userPropertyManager.getPropertySet(profileUser);
            for (String key : userPropertySet.getKeys(5)) {
                if (!key.startsWith("jira.meta.")) continue;
                userProperties.put(key.substring("jira.meta.".length()), userPropertySet.getString(key));
            }
        }
        return userProperties;
    }

    private Iterable<String> getGroupsForUser(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    public class Context {
        @Nonnull
        private final ApplicationUser profileUser;
        private final ApplicationUser currentUser;

        public Context(ApplicationUser profileUser, ApplicationUser currentUser) {
            this.profileUser = (ApplicationUser)Preconditions.checkNotNull((Object)profileUser);
            this.currentUser = currentUser;
        }

        public boolean isCanEditAvatar() {
            return DetailsUserProfilePanel.this.avatarManager.hasPermissionToEdit(this.currentUser, this.profileUser);
        }
    }
}

