/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.userprofile;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.userprofile.AbstractUserProfilePanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;

public class AssignedAndOpenUserProfilePanel
extends AbstractUserProfilePanel {
    private final PermissionManager permissionManager;
    private final SearchService searchService;

    public AssignedAndOpenUserProfilePanel(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, SearchService searchService) {
        super(jiraAuthenticationContext);
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    public boolean showFragment(ApplicationUser profileUser, ApplicationUser currentUser) {
        return Iterables.any((Iterable)this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, currentUser), (Predicate)Predicates.in((Collection)this.permissionManager.getProjects(ProjectPermissions.ASSIGNABLE_USER, profileUser)));
    }

    public Map<String, Object> getContextMap(Map<String, Object> initialContext) {
        ApplicationUser profileUser = (ApplicationUser)initialContext.get("profileUser");
        ApplicationUser currentUser = (ApplicationUser)initialContext.get("currentUser");
        Map<String, Object> params = this.createVelocityParams(profileUser, currentUser);
        params.put("panelId", this.getId());
        params.put("projects", this.getProjects(profileUser, currentUser));
        params.put("urlBuilder", new UrlBuilder(profileUser, currentUser));
        return params;
    }

    @Override
    public String getId() {
        return "assigned-and-open";
    }

    private StatisticMapWrapper getProjects(ApplicationUser profileUser, ApplicationUser currentUser) {
        JqlClauseBuilder builder = this.getBaseQuery(profileUser, currentUser);
        SearchRequest request = new SearchRequest(builder.buildQuery());
        try {
            StatisticAccessorBean bean = new StatisticAccessorBean(currentUser, request);
            return bean.getAllFilterBy("project");
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private JqlClauseBuilder getBaseQuery(ApplicationUser profileUser, ApplicationUser currentUser) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        if (profileUser.equals((Object)currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        return builder;
    }

    public class UrlBuilder {
        private final ApplicationUser profileUser;
        private final ApplicationUser currentUser;

        public UrlBuilder(ApplicationUser profileUser, ApplicationUser currentUser) {
            this.profileUser = profileUser;
            this.currentUser = currentUser;
        }

        public String getUrl(Project project) {
            JqlClauseBuilder builder = AssignedAndOpenUserProfilePanel.this.getBaseQuery(this.profileUser, this.currentUser);
            builder.and().project(new Long[]{project.getId()});
            return AssignedAndOpenUserProfilePanel.this.searchService.getQueryString(this.currentUser, builder.buildQuery());
        }
    }
}

