/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;

public class PluginDependencies {
    private final Set<String> mandatory;
    private final Set<String> optional;
    private final Set<String> dynamic;
    private final Set<String> all;
    private final Multimap<String, Type> byPluginKey;

    public PluginDependencies() {
        this(null, null, null);
    }

    public PluginDependencies(Set<String> mandatory, Set<String> optional, Set<String> dynamic) {
        this.mandatory = mandatory == null ? ImmutableSet.of() : ImmutableSet.copyOf(mandatory);
        this.optional = optional == null ? ImmutableSet.of() : ImmutableSet.copyOf(optional);
        this.dynamic = dynamic == null ? ImmutableSet.of() : ImmutableSet.copyOf(dynamic);
        this.all = ImmutableSet.builder().addAll(this.mandatory).addAll(this.optional).addAll(this.dynamic).build();
        ImmutableListMultimap.Builder byPluginKey = ImmutableListMultimap.builder();
        for (String key : this.mandatory) {
            byPluginKey.put((Object)key, (Object)Type.MANDATORY);
        }
        for (String key : this.optional) {
            byPluginKey.put((Object)key, (Object)Type.OPTIONAL);
        }
        for (String key : this.dynamic) {
            byPluginKey.put((Object)key, (Object)Type.DYNAMIC);
        }
        this.byPluginKey = byPluginKey.build();
    }

    public Set<String> getMandatory() {
        return this.mandatory;
    }

    public Set<String> getOptional() {
        return this.optional;
    }

    public Set<String> getDynamic() {
        return this.dynamic;
    }

    public Set<String> getAll() {
        return this.all;
    }

    public Multimap<String, Type> getByPluginKey() {
        return this.byPluginKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final ImmutableSet.Builder<String> mandatory = new ImmutableSet.Builder();
        final ImmutableSet.Builder<String> optional = new ImmutableSet.Builder();
        final ImmutableSet.Builder<String> dynamic = new ImmutableSet.Builder();

        private Builder() {
        }

        public Builder withMandatory(String ... pluginKey) {
            this.mandatory.add((Object[])pluginKey);
            return this;
        }

        public Builder withOptional(String ... pluginKey) {
            this.optional.add((Object[])pluginKey);
            return this;
        }

        public Builder withDynamic(String ... pluginKey) {
            this.dynamic.add((Object[])pluginKey);
            return this;
        }

        public PluginDependencies build() {
            return new PluginDependencies((Set<String>)this.mandatory.build(), (Set<String>)this.optional.build(), (Set<String>)this.dynamic.build());
        }
    }

    public static enum Type {
        MANDATORY,
        OPTIONAL,
        DYNAMIC;


        public boolean lessSignificant(Type other) {
            return this.ordinal() > other.ordinal();
        }
    }
}

