/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.projectcreate.crud;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.projectcreate.spi.AggregateRoot;
import com.atlassian.plugins.projectcreate.spi.AggregateRootSubType;
import com.atlassian.plugins.projectcreate.spi.AggregateRootTypeCapability;
import com.atlassian.plugins.projectcreate.spi.ResponseStatusWithMessage;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={AggregateRootTypeCapability.class})
@Component
public class JiraAggregateRootTypeCapability
implements AggregateRootTypeCapability {
    public static final String PROJECT_NAME_ERROR_KEY = "projectName";
    public static final String PROJECT_KEY_ERROR_KEY = "projectKey";
    private final PluginAccessor pluginAccessor;
    private final ProjectManager projectManager;
    private final ProjectService projectService;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private static final String GREENHOPPER_PLUGIN_KEY = "com.pyxis.greenhopper.jira";
    private static final AggregateRootSubType KANBAN_SUBTYPE = new AggregateRootSubType("kanban", "jira.projectcreate.project.kanban.label", false);
    private static final AggregateRootSubType SCRUM_SUBTYPE = new AggregateRootSubType("scrum", "jira.projectcreate.project.scrum.label", false);
    private static final AggregateRootSubType STANDARD_SUBTYPE = new AggregateRootSubType("standard", "jira.projectcreate.project.standard.label", true);
    public static final Function<Project, AggregateRoot> PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION = new Function<Project, AggregateRoot>(){

        public AggregateRoot apply(Project input) {
            return AggregateRoot.makeAggregateRoot((String)input.getKey(), (String)input.getName(), (String)"/browse/");
        }
    };

    @Autowired
    public JiraAggregateRootTypeCapability(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport ProjectService projectService, @ComponentImport UserManager userManager, @ComponentImport PermissionManager permissionManager) {
        this.pluginAccessor = pluginAccessor;
        this.projectManager = projectManager;
        this.projectService = projectService;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    public String getType() {
        return "jira.project";
    }

    public String getLabelI18nKey() {
        return "jira.projectcreate.project.label";
    }

    public String getDescriptionI18nKey() {
        return "jira.projectcreate.project.description";
    }

    public boolean isAvailable() {
        return true;
    }

    public Iterable<AggregateRootSubType> getSubTypes() {
        Plugin plugin = this.pluginAccessor.getPlugin(GREENHOPPER_PLUGIN_KEY);
        return plugin != null ? ImmutableList.of((Object)KANBAN_SUBTYPE, (Object)SCRUM_SUBTYPE, (Object)STANDARD_SUBTYPE) : ImmutableList.of();
    }

    public Iterable<AggregateRoot> getExistingRoots() {
        return Iterables.transform((Iterable)this.projectManager.getProjectObjects(), PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION);
    }

    public Either<ResponseStatusWithMessage, AggregateRoot> createRoot(String username, String key, String name, Option<String> subtypeKey, Map<String, String> context) {
        ApplicationUser user = this.userManager.getUserByKey(username);
        if (Strings.isNullOrEmpty((String)name)) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, "jira.projectcreate.project.name.not.provided", new String[0]));
        }
        if (name.length() < 2) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, "jira.projectcreate.project.name.too.short", new String[0]));
        }
        if (name.length() > this.projectService.getMaximumNameLength()) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, "jira.projectcreate.project.name.too.long", new String[0]));
        }
        ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(user, new ProjectCreationData.Builder().withName(name).withKey(key).withType("business").withDescription("").withLead(user).withUrl(null).withAssigneeType(Long.valueOf(2L)).build());
        if (createProjectValidationResult.isValid()) {
            Project project = this.projectService.createProject(createProjectValidationResult);
            return Either.right((Object)PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION.apply((Object)project));
        }
        Map errors = createProjectValidationResult.getErrorCollection().getErrors();
        if (errors.containsKey(PROJECT_KEY_ERROR_KEY)) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, (String)errors.get(PROJECT_KEY_ERROR_KEY), new String[0]));
        }
        if (errors.size() == 1 && errors.containsKey(PROJECT_NAME_ERROR_KEY)) {
            return this.createRoot(username, key, this.mutateNonUniqueName(name), subtypeKey, context);
        }
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)createProjectValidationResult.getErrorCollection().getReasons());
        worstReason = worstReason != null ? worstReason : ErrorCollection.Reason.VALIDATION_FAILED;
        Iterator iterator = createProjectValidationResult.getErrorCollection().getErrorMessages().iterator();
        if (iterator.hasNext()) {
            String message = (String)iterator.next();
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.fromStatusCode((int)worstReason.getHttpStatusCode()), message, new String[0]));
        }
        return Either.left((Object)new ResponseStatusWithMessage(Response.Status.fromStatusCode((int)worstReason.getHttpStatusCode()), "", new String[0]));
    }

    public boolean canUserCreateRoot(String username) {
        ApplicationUser user = this.userManager.getUserByKey(username);
        return this.permissionManager.hasPermission(0, user);
    }

    public Option<AggregateRoot> getRootByKey(Option<String> maybeUsername, String entityKey) {
        ApplicationUser user = this.userManager.getUserByKey((String)maybeUsername.getOrNull());
        ProjectService.GetProjectResult project = this.projectService.getProjectByKey(user, entityKey);
        if (!project.isValid()) {
            return Option.none();
        }
        return Option.some((Object)PROJECT_TO_AGGREGATE_ROOT_MAP_FUNCTION.apply((Object)project.getProject()));
    }

    public Either<ResponseStatusWithMessage, ResponseStatusWithMessage> deleteRoot(String username, String entityKey) {
        ApplicationUser user = this.userManager.getUserByKey(username);
        ProjectService.DeleteProjectValidationResult deleteProjectValidationResult = this.projectService.validateDeleteProject(user, entityKey);
        if (!deleteProjectValidationResult.isValid()) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.UNAUTHORIZED, "admin.projects.service.error.no.admin.permission", new String[0]));
        }
        ProjectService.DeleteProjectResult deleteProjectResult = this.projectService.deleteProject(user, deleteProjectValidationResult);
        if (deleteProjectResult.isValid()) {
            return Either.right((Object)new ResponseStatusWithMessage(Response.Status.NO_CONTENT, "", new String[0]));
        }
        return Either.left((Object)new ResponseStatusWithMessage(Response.Status.INTERNAL_SERVER_ERROR, "", new String[0]));
    }

    public void flushPluginSettings() {
    }

    private String mutateNonUniqueName(String name) {
        return name + ".";
    }
}

