/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soy;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SoyCacheFlusher
implements InitializingBean,
DisposableBean {
    private EventPublisher eventPublisher;
    private SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public SoyCacheFlusher(@ComponentImport EventPublisher eventPublisher, @ComponentImport SoyTemplateRenderer soyTemplateRenderer) {
        this.eventPublisher = eventPublisher;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flushSoyCache();
    }

    public boolean flushSoyCache() {
        try {
            this.soyTemplateRenderer.clearAllCaches();
            return true;
        }
        catch (Exception anything) {
            return false;
        }
    }
}

