/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryEntities {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEntities.class);
    public static final Function<DirectoryEntity, String> NAME_FUNCTION = DirectoryEntity::getName;
    public static final Function<DirectoryEntity, String> LOWER_NAME_FUNCTION = Functions.compose((Function)IdentifierUtils.TO_LOWER_CASE, NAME_FUNCTION);

    public static Iterable<String> namesOf(Iterable<? extends DirectoryEntity> entities) {
        return Iterables.transform(entities, NAME_FUNCTION);
    }

    public static <T extends DirectoryEntity> List<T> filterOutDuplicates(List<T> remoteEntities) {
        LinkedHashMap entityMap = Maps.newLinkedHashMap();
        HashSet badEntities = Sets.newHashSet();
        for (DirectoryEntity remoteEntity : remoteEntities) {
            DirectoryEntity origEntity;
            String entityId = IdentifierUtils.toLowerCase((String)remoteEntity.getName());
            if (badEntities.contains(entityId) || (origEntity = entityMap.put(entityId, remoteEntity)) == null) continue;
            entityMap.remove(entityId);
            badEntities.add(entityId);
            if (!origEntity.getName().equals(remoteEntity.getName())) {
                log.warn("entity [{}] of type {} duplicated in remote directory by entity [{}]. Ignoring all occurrences.", new Object[]{origEntity.getName(), remoteEntity.getClass().getSimpleName(), remoteEntity.getName()});
                continue;
            }
            log.warn("entity [{}] of type {} duplicated in remote directory. Ignoring all occurrences.", (Object)origEntity.getName(), (Object)remoteEntity.getClass().getSimpleName());
        }
        return badEntities.isEmpty() ? remoteEntities : ImmutableList.copyOf(entityMap.values());
    }
}

