/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.api.NotificationInspector;
import com.atlassian.jira.customfieldhelper.impl.context.DefaultNotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.engine.NotificationInspectionEngine;
import com.atlassian.jira.customfieldhelper.rest.FieldInfoRequestUserValidator;
import com.atlassian.jira.customfieldhelper.rest.InspectorFactory;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestExceptionFactory;
import com.atlassian.jira.customfieldhelper.rest.NotificationInfoJson;
import com.atlassian.jira.customfieldhelper.rest.RestValidationHelper;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="notifications")
@Produces(value={"application/json"})
public class NotificationsResource {
    private final FieldInfoRequestUserValidator userValidator;
    private final InvalidRequestExceptionFactory exceptionFactory;
    private final InspectorFactory inspectorFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory requestContextFactory;
    private final NotificationSchemeManager notificationSchemeManager;
    private final EventTypeManager eventTypeManager;
    private final RestValidationHelper restValidationHelper;
    private final UserPreferencesManager userPreferencesManager;

    public NotificationsResource(FieldInfoRequestUserValidator userValidator, InvalidRequestExceptionFactory exceptionFactory, InspectorFactory inspectorFactory, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory requestContextFactory, NotificationSchemeManager notificationSchemeManager, EventTypeManager eventTypeManager, RestValidationHelper restValidationHelper, UserPreferencesManager userPreferencesManager) {
        this.userValidator = userValidator;
        this.exceptionFactory = exceptionFactory;
        this.inspectorFactory = inspectorFactory;
        this.authenticationContext = jiraAuthenticationContext;
        this.notificationSchemeManager = notificationSchemeManager;
        this.requestContextFactory = requestContextFactory;
        this.eventTypeManager = eventTypeManager;
        this.restValidationHelper = restValidationHelper;
        this.userPreferencesManager = userPreferencesManager;
    }

    @GET
    public Response getUserInfoForIssue(@QueryParam(value="username") String username, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="eventId") Long eventId) {
        try {
            this.userValidator.validateAndGet();
            ApplicationUser user = this.restValidationHelper.validateInspectedUser(username);
            Issue issue = this.restValidationHelper.validateIssue(issueKey);
            EventType eventType = this.validateEvent(eventId);
            NotificationInspectionContext context = this.createContext(user, issue, eventType);
            NotificationInspectionEngine engine = new NotificationInspectionEngine((Iterable<? extends NotificationInspector>)this.inspectorFactory.getNotificationInspectors());
            return Response.ok((Object)this.createOkResponse(engine.run(context), context)).cacheControl(NotificationsResource.dontCache()).build();
        }
        catch (InvalidRequestException invalidRequest) {
            return invalidRequest.response();
        }
    }

    private EventType validateEvent(Long eventId) {
        try {
            return this.eventTypeManager.getEventType(eventId);
        }
        catch (IllegalArgumentException e) {
            String message = this.restValidationHelper.getI18n().getText("whereismycf.error.eventtypenotfound", (Object)eventId);
            throw this.exceptionFactory.failedWithFieldError(Response.Status.BAD_REQUEST, "event", message);
        }
    }

    private NotificationInspectionContext createContext(ApplicationUser user, Issue issue, EventType event) {
        Project project = issue.getProjectObject();
        Boolean notifyOwnChanges = this.userPreferencesManager.getPreferences(user).getBoolean("user.notify.own.changes");
        return new DefaultNotificationInspectionContext(event, this.notificationSchemeManager.getSchemeFor(project), issue, this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), user, notifyOwnChanges, this.authenticationContext.getI18nHelper(), this.authenticationContext.getLoggedInUser());
    }

    private Object createOkResponse(Iterable<InspectionNote> notes, NotificationInspectionContext context) {
        return NotificationInfoJson.createInfoBean(notes, context);
    }

    private static javax.ws.rs.core.CacheControl dontCache() {
        return CacheControl.never();
    }
}

