/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.rest.FieldInfoRequestUserValidator;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestExceptionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFieldInfoRequestUserValidator
implements FieldInfoRequestUserValidator {
    private final InvalidRequestExceptionFactory exceptionFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    @Autowired
    public DefaultFieldInfoRequestUserValidator(InvalidRequestExceptionFactory exceptionFactory, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.exceptionFactory = exceptionFactory;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public ApplicationUser validateAndGet() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            throw this.exceptionFactory.failedWithMessage(Response.Status.UNAUTHORIZED, "whereismycf.error.anonymous", new Object[0]);
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            throw this.exceptionFactory.failedWithMessage(Response.Status.UNAUTHORIZED, "whereismycf.error.notanadmin", new Object[0]);
        }
        return user;
    }
}

