/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class GroupCfInspector
implements SchemeInspector {
    private final GroupManager groupManager;
    private final CustomFieldManager customFieldManager;

    public GroupCfInspector(GroupManager groupManager, CustomFieldManager customFieldManager) {
        this.groupManager = groupManager;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public InspectionNote inspect(SchemeEntity schemeEntity, InspectionContext context) {
        if (context.isAnonymous()) {
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.anonymous.cannot.meet")).build();
        }
        String customFieldId = schemeEntity.getParameter();
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField != null) {
            Collection<Group> groups = this.getGroups(context.issue().getCustomFieldValue(customField));
            Collection<Group> groupsForUser = this.getGroupsForUser(context.user(), groups);
            if (!groupsForUser.isEmpty()) {
                if (groupsForUser.size() == 1) {
                    return InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.cfgroup.single.ok").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(this.asString(groupsForUser)).addPlainParameter(customField.getName()).build()).build();
                }
                return InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.cfgroup.multi.ok").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(this.asString(groupsForUser)).addPlainParameter(customField.getName()).build()).build();
            }
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.cfuser.problem").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(customField.getName()).build()).build();
        }
        return null;
    }

    private Collection<Group> getGroups(Object customFieldValue) {
        if (customFieldValue == null) {
            return Collections.emptyList();
        }
        if (customFieldValue instanceof Group) {
            return Arrays.asList((Group)customFieldValue);
        }
        if (customFieldValue instanceof Collection) {
            Collection collection = (Collection)customFieldValue;
            ArrayList<Group> groups = new ArrayList<Group>(collection.size());
            for (Object obj : collection) {
                if (!(obj instanceof Group)) continue;
                groups.add((Group)obj);
            }
            return groups;
        }
        return Collections.emptyList();
    }

    private Collection<Group> getGroupsForUser(ApplicationUser user, Collection<Group> groups) {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Group> result = new ArrayList<Group>(groups.size());
        for (Group group : groups) {
            if (!this.groupManager.isUserInGroup(user, group)) continue;
            result.add(group);
        }
        return result;
    }

    private String asString(Collection<Group> groups) {
        return StringUtils.join((Collection)Collections2.transform(groups, (Function)new Function<Group, String>(){

            public String apply(Group group) {
                return group.getName();
            }
        }), (String)", ");
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.cfgroup.summary");
    }
}

