/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ProjectPermissionSingleInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;
    private final String type;
    private final SchemeInspector inspector;

    public ProjectPermissionSingleInspector(@Nonnull PermissionSchemeManager permissionSchemeManager, @Nonnull String type, @Nonnull SchemeInspector inspector) {
        Preconditions.checkNotNull((Object)type);
        this.permissionSchemeManager = permissionSchemeManager;
        this.type = type;
        this.inspector = inspector;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(@Nonnull PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            return Collections.emptyList();
        }
        if (context.permission() == null) {
            return Collections.emptyList();
        }
        ProjectPermissionKey permissionKey = context.permission().getProjectPermissionKey();
        List entities = permissionScheme.getEntitiesByType((Object)permissionKey);
        return SchemeTypes.forEach(entities, context, this.type, this.inspector);
    }
}

