/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class SecurityLevelFieldInspector
extends AbstractFieldInspector<SecurityLevelSystemField> {
    private final IssueSecuritySchemeManager securitySchemeManager;
    private final PermissionManager permissionManager;

    public SecurityLevelFieldInspector(IssueSecuritySchemeManager securitySchemeManager, PermissionManager permissionManager) {
        super(SecurityLevelSystemField.class);
        this.securitySchemeManager = securitySchemeManager;
        this.permissionManager = permissionManager;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(SecurityLevelSystemField field, FieldInspectionContext context) {
        ImmutableList.Builder results = ImmutableList.builder();
        if (field.isShown(context.issue())) {
            results.add((Object)this.createOk(field, context));
            if (this.isNonViewOp(context)) {
                results.add((Object)this.createPermissionOk(field, context));
            }
        } else {
            if (this.securitySchemeManager.getSchemeFor(context.project()) == null) {
                results.add((Object)this.createNoSecurityScheme(field, context));
            }
            if (this.isNonViewOp(context) && !this.permissionManager.hasPermission(26, context.issue(), context.user())) {
                results.add((Object)this.createNoPermission(field, context));
            }
        }
        return results.build();
    }

    private boolean isNonViewOp(FieldInspectionContext context) {
        return context.issueOperation() != IssueOperations.VIEW_ISSUE_OPERATION;
    }

    private InspectionNote createOk(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context)).build();
    }

    private InspectionNote createPermissionOk(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createPermissionSummary(context)).addDetails(this.createOkPermissionDetails(context)).build();
    }

    private InspectionNote createNoSecurityScheme(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createSchemeProblemDetails(field, context)).build();
    }

    private InspectionNote createNoPermission(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createPermissionProblemDetails(field, context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.summary").build();
    }

    private InspectionMessage createPermissionSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.permission.summary").build();
    }

    private InspectionMessage createOkDetails(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.ok").build();
    }

    private InspectionMessage createOkPermissionDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.permission.ok").build();
    }

    private InspectionMessage createSchemeProblemDetails(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.problem.nosecurityscheme").addPlainParameter(context.project().getName()).addNewLine().newI18nLinkParameter().textKey("whereismycf.inspection.securitylevel.problem.nosecurityscheme.linktext.projectsecurityconfig").textParams(context.project().getName()).pathKey("whereismycf.inspection.link.projectsecurity").urlParams(context.project().getKey()).add().build();
    }

    private InspectionMessage createPermissionProblemDetails(SecurityLevelSystemField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.securitylevel.problem.nopermission").addNewLine().addLinkParameterFromI18n("whereismycf.inspection.securitylevel.problem.nopermission.linktext.permissions", "whereismycf.inspection.link.projectpermissions", context.project().getKey()).addLinkParameterFromI18n("whereismycf.inspection.securitylevel.problem.nopermission.linktext.people", "whereismycf.inspection.link.projectpeople", context.project().getKey()).addPlainParameter(context.project().getName()).build();
    }
}

