/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ResolutionDateValueInspector
extends AbstractFieldInspector<ResolutionDateSystemField>
implements FieldInspector<ResolutionDateSystemField> {
    public ResolutionDateValueInspector() {
        super(ResolutionDateSystemField.class);
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(ResolutionDateSystemField field, FieldInspectionContext context) {
        if (context.issueOperation() != IssueOperations.VIEW_ISSUE_OPERATION) {
            return Collections.emptyList();
        }
        if (context.issue().getResolutionDate() != null) {
            return ImmutableList.of((Object)this.createOk(field, context));
        }
        return ImmutableList.of((Object)this.createProblem(field, context));
    }

    private InspectionNote createOk(ResolutionDateSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context)).build();
    }

    private InspectionNote createProblem(ResolutionDateSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails((Field)field, context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.resolutiondate.view.summary");
    }

    private InspectionMessage createOkDetails(ResolutionDateSystemField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.resolutiondate.view.ok");
    }

    private InspectionMessage createProblemDetails(Field field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.resolutiondate.view.problem").addPlainParameter(context.issue().getKey()).build();
    }
}

