/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractCustomFieldInspector;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class ContextScopeInspector
extends AbstractCustomFieldInspector
implements FieldInspector<CustomField> {
    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(CustomField field, FieldInspectionContext context) {
        if (field.isInScope(context.project(), (List)ImmutableList.of((Object)context.issueType().getId()))) {
            return ImmutableList.of((Object)this.createOkNote(field, context));
        }
        return ImmutableList.of((Object)this.createProblemNote(field, context));
    }

    private InspectionNote createOkNote(CustomField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(ContextScopeInspector.summary(context)).addDetails(this.createOkDetails(field, context)).build();
    }

    private InspectionNote createProblemNote(CustomField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(ContextScopeInspector.summary(context)).addDetails(this.createProblemDetails(field, context)).build();
    }

    private static InspectionMessage summary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.context.summary").build();
    }

    private InspectionMessage createOkDetails(CustomField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.context.ok").addPlainParameter(field.getName()).addPlainParameter(context.project().getName()).addPlainParameter(context.issueTypeName()).build();
    }

    private InspectionMessage createProblemDetails(CustomField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.context.problem").addPlainParameter(field.getName()).addPlainParameter(context.project().getName()).addPlainParameter(context.issueTypeName()).addNewLine().newI18nLinkParameter().textKey("whereismycf.inspection.context.problem.linktext.customfieldcontext").textParams(field.getName()).pathKey("whereismycf.inspection.link.customfieldcontextconfig").urlParams(field.getIdAsLong()).add().build();
    }
}

