/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.api;

import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public final class InspectionNote {
    private final Status status;
    private final boolean required;
    private final Iterable<InspectionMessage> summary;
    private final Iterable<InspectionMessage> details;

    public static Builder ok() {
        return new Builder(Status.OK);
    }

    public static Builder ok(InspectionMessage summary) {
        return new Builder(Status.OK, summary);
    }

    public static Builder problem() {
        return new Builder(Status.NOT_OK);
    }

    public static Builder problem(InspectionMessage summary) {
        return new Builder(Status.NOT_OK, summary);
    }

    private InspectionNote(Builder builder) {
        this.status = builder.status;
        this.summary = this.validateAndGetSummary(builder);
        this.required = builder.required;
        this.details = builder.details.build();
    }

    private Iterable<InspectionMessage> validateAndGetSummary(Builder builder) {
        ImmutableList summaries = builder.summary.build();
        Preconditions.checkState((!summaries.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one summary line");
        return summaries;
    }

    public Status status() {
        return this.status;
    }

    public boolean required() {
        return this.required;
    }

    public Iterable<InspectionMessage> summary() {
        return this.summary;
    }

    public Iterable<InspectionMessage> details() {
        return this.details;
    }

    public static final class Builder {
        private final Status status;
        private boolean required = false;
        private final ImmutableList.Builder<InspectionMessage> summary = ImmutableList.builder();
        private final ImmutableList.Builder<InspectionMessage> details = ImmutableList.builder();

        public Builder(Status status) {
            this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        }

        public Builder(Status status, InspectionMessage summary) {
            this(status);
            this.summary.add((Object)summary);
        }

        public Builder addSummary(InspectionMessage ... summary) {
            this.summary.add((Object[])summary);
            return this;
        }

        public Builder addSummary(Iterable<InspectionMessage> summary) {
            this.summary.addAll(summary);
            return this;
        }

        public Builder addDetails(InspectionMessage ... details) {
            this.details.add((Object[])details);
            return this;
        }

        public Builder addDetails(Iterable<InspectionMessage> details) {
            this.details.addAll(details);
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public InspectionNote build() {
            return new InspectionNote(this);
        }
    }

    public static enum Status {
        OK,
        NOT_OK;


        public Status and(Status next) {
            return this == NOT_OK || next == NOT_OK ? NOT_OK : OK;
        }

        public Status or(Status next) {
            return this == OK || next == OK ? OK : NOT_OK;
        }
    }
}

