/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.api;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageParameter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class InspectionMessageBuilder {
    private final InspectionContext context;
    private String template;
    private List<InspectionMessageParameter> parameters = Lists.newArrayList();

    public static InspectionMessage newSimpleMessage(InspectionContext context, String messageKey) {
        return InspectionMessageBuilder.forContext(context).templateKey(messageKey).build();
    }

    public static InspectionMessageBuilder forContext(InspectionContext context) {
        return new InspectionMessageBuilder(context);
    }

    public InspectionMessageBuilder(InspectionContext context) {
        this.context = (InspectionContext)Preconditions.checkNotNull((Object)context, (Object)"context");
    }

    public InspectionMessageBuilder templateKey(String key) {
        this.template = this.context.i18n().getText(key);
        return this;
    }

    public InspectionMessageBuilder text(String text) {
        this.template = text;
        return this;
    }

    public InspectionMessageBuilder addNewLine() {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.NEWLINE, new String[0]));
        return this;
    }

    public InspectionMessageBuilder addTagStart(String tagName) {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.TAG_START, tagName));
        return this;
    }

    public InspectionMessageBuilder addTagEnd(String tagName) {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.TAG_END, tagName));
        return this;
    }

    public InspectionMessageBuilder addPlainParameter(String value) {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.PLAIN, value));
        return this;
    }

    public InspectionMessageBuilder addPlainParameterFromI18n(String i18nKey) {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.PLAIN, this.context.i18n().getText(i18nKey)));
        return this;
    }

    public InspectionMessageBuilder addLinkParameter(String text, String path) {
        this.parameters.add(new InspectionMessageParameter(InspectionMessageParameter.Type.LINK, text, this.context.baseUrl() + path));
        return this;
    }

    public InspectionMessageBuilder addLinkParameterFromI18n(String textKey, String pathKey, Object ... urlArguments) {
        return this.addLinkParameter(this.context.i18n().getText(textKey), this.context.i18n().getText(pathKey, (Object)urlArguments));
    }

    public I18nLinkParameterBuilder newI18nLinkParameter() {
        return new I18nLinkParameterBuilder();
    }

    public InspectionMessage build() {
        return new InspectionMessage(this.template, this.parameters);
    }

    public final class I18nLinkParameterBuilder {
        private String textKey;
        private final ImmutableList.Builder<Object> textParams = ImmutableList.builder();
        private String pathKey;
        private final ImmutableList.Builder<Object> urlParams = ImmutableList.builder();

        private I18nLinkParameterBuilder() {
        }

        public I18nLinkParameterBuilder textKey(String textKey) {
            this.textKey = textKey;
            return this;
        }

        public I18nLinkParameterBuilder textParams(Object ... params) {
            this.textParams.add(params);
            return this;
        }

        public I18nLinkParameterBuilder pathKey(String pathKey) {
            this.pathKey = pathKey;
            return this;
        }

        public I18nLinkParameterBuilder urlParams(Object ... urlParams) {
            this.urlParams.add(urlParams);
            return this;
        }

        public InspectionMessageBuilder add() {
            return this.parent().addLinkParameter(this.parent().context.i18n().getText(this.textKey, (Object)this.textParams.build()), this.parent().context.i18n().getText(this.pathKey, (Object)this.urlParams.build()));
        }

        private InspectionMessageBuilder parent() {
            return InspectionMessageBuilder.this;
        }
    }
}

