/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.util;

import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationRecipientUtil {
    private static final Logger log = LoggerFactory.getLogger(NotificationRecipientUtil.class);
    private final UserManager userManager;

    @Autowired
    public NotificationRecipientUtil(@ComponentImport UserManager userManager) {
        this.userManager = userManager;
    }

    public Set<NotificationRecipient> filterOutAuthorAndReceiver(final ApplicationUser authorUser, List<NotificationRecipient> allRecipients, final NotificationRecipient notificationReceiver) {
        return Sets.filter((Set)Sets.newHashSet(allRecipients), (Predicate)new Predicate<NotificationRecipient>(){

            public boolean apply(@Nullable NotificationRecipient recipient) {
                return this.isNotNotificationReceiver(recipient) && !this.isAuthor(recipient);
            }

            private boolean isAuthor(NotificationRecipient recipient) {
                if (authorUser == null || recipient == null) {
                    return false;
                }
                if (recipient.getUser() != null) {
                    ApplicationUser user = recipient.getUser();
                    return authorUser.equals((Object)user);
                }
                if (recipient.getEmail() != null && authorUser.getEmailAddress() != null) {
                    return recipient.getEmail().equals(authorUser.getEmailAddress());
                }
                return false;
            }

            private boolean isNotNotificationReceiver(NotificationRecipient recipient) {
                return recipient != notificationReceiver;
            }
        });
    }

    public List<NotificationRecipient> getRecipients(ShareBean shareBean) {
        ArrayList recipients = Lists.newArrayList();
        List<NotificationRecipient> userNamesRecipients = this.getRecipientsFromUserNames(shareBean);
        List<NotificationRecipient> emailRecipients = this.getRecipientsFromEmails(shareBean);
        recipients.addAll(userNamesRecipients);
        recipients.addAll(emailRecipients);
        return recipients;
    }

    private List<NotificationRecipient> getRecipientsFromUserNames(ShareBean shareBean) {
        ArrayList recipients = Lists.newArrayList();
        if (shareBean.getUsernames() != null) {
            for (String toUsername : shareBean.getUsernames()) {
                ApplicationUser user = this.userManager.getUserByName(toUsername);
                if (user != null) {
                    recipients.add(new NotificationRecipient(user));
                    continue;
                }
                log.warn("No user found for name: " + toUsername);
            }
        }
        return recipients;
    }

    private List<NotificationRecipient> getRecipientsFromEmails(ShareBean shareBean) {
        ArrayList recipients = Lists.newArrayList();
        if (shareBean.getEmails() != null) {
            for (String toEmail : shareBean.getEmails()) {
                recipients.add(new NotificationRecipient(toEmail));
            }
        }
        return recipients;
    }
}

