/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.search;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.plugins.share.event.AbstractShareEvent;
import com.atlassian.jira.plugins.share.event.ShareJqlEvent;
import com.atlassian.jira.plugins.share.event.ShareSearchRequestEvent;
import com.atlassian.jira.plugins.share.search.ShareSearchEmailsSender;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShareSearchRequestService {
    private final EventPublisher eventPublisher;
    private final ShareSearchEmailsSender shareSearchEmailsSender;

    @Autowired
    public ShareSearchRequestService(@ComponentImport EventPublisher eventPublisher, ShareSearchEmailsSender shareSearchEmailsSender) {
        this.eventPublisher = eventPublisher;
        this.shareSearchEmailsSender = shareSearchEmailsSender;
    }

    public void shareSearchRequest(ShareService.ValidateShareSearchRequestResult result) {
        Map<String, Object> params = this.prepareParams(result);
        this.shareSearchEmailsSender.sendShareSearchEmails(result, params);
        this.publishShareEvent(result);
    }

    private Map<String, Object> prepareParams(ShareService.ValidateShareSearchRequestResult result) {
        HashMap params = Maps.newHashMap();
        params.put("remoteUser", result.getUser());
        this.prepareJqlParams(result, params);
        String message = result.getShareBean().getMessage();
        if (StringUtils.isNotBlank((String)message)) {
            params.put("comment", message);
            params.put("htmlComment", TextUtils.htmlEncode((String)message));
        }
        return params;
    }

    private void prepareJqlParams(ShareService.ValidateShareSearchRequestResult result, Map<String, Object> params) {
        String jql = this.getJql(result);
        UrlBuilder jqlUrlBuilder = new UrlBuilder(false);
        jqlUrlBuilder.addParameter("jql", jql);
        params.put("jqlSearchLinkUrlParams", jqlUrlBuilder.asUrlString());
        if (result.getSearchRequest() != null) {
            this.putSearchRequestParams(params, result.getSearchRequest());
        }
    }

    private String getJql(final ShareService.ValidateShareSearchRequestResult result) {
        return (String)Option.option((Object)result.getSearchRequest()).fold((Supplier)new Supplier<String>(){

            public String get() {
                return result.getShareBean().getJql();
            }
        }, (Function)new Function<SearchRequest, String>(){

            public String apply(SearchRequest request) {
                return request.getQuery().getQueryString();
            }
        });
    }

    private void putSearchRequestParams(Map<String, Object> params, SearchRequest searchRequest) {
        UrlBuilder savedSearchUrlBuilder = new UrlBuilder(false);
        savedSearchUrlBuilder.addParameter("filter", (Object)searchRequest.getId());
        params.put("savedSearchLinkUrlParams", savedSearchUrlBuilder.asUrlString());
        params.put("filterName", searchRequest.getName());
    }

    private void publishShareEvent(ShareService.ValidateShareSearchRequestResult result) {
        AbstractShareEvent event = this.getProperEvent(result.getSearchRequest(), result.getShareBean(), result.getUser());
        this.eventPublisher.publish((Object)event);
    }

    private AbstractShareEvent getProperEvent(SearchRequest searchRequest, final ShareBean shareSearchBean, final ApplicationUser user) {
        return (AbstractShareEvent)Option.option((Object)searchRequest).fold((Supplier)new Supplier<AbstractShareEvent>(){

            public AbstractShareEvent get() {
                return new ShareJqlEvent(user, shareSearchBean.getUsernames(), shareSearchBean.getEmails(), shareSearchBean.getMessage(), shareSearchBean.getJql());
            }
        }, (Function)new Function<SearchRequest, AbstractShareEvent>(){

            public AbstractShareEvent apply(SearchRequest request) {
                return new ShareSearchRequestEvent(user, shareSearchBean.getUsernames(), shareSearchBean.getEmails(), shareSearchBean.getMessage(), request);
            }
        });
    }
}

