/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.search;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.plugins.share.util.NotificationRecipientUtil;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ShareSearchEmailsSender {
    public static final String SAVED_SEARCH_TEMPLATE = "share-saved-search.vm";
    public static final String SHARE_JQL_TEMPLATE = "share-jql-search.vm";
    public static final String BODY_TEMPLATE_PATH = "templates/email/";
    public static final String SUBJECT_TEMPLATE_PATH = "templates/email/subject/";
    public static final char PATH_SEPARATOR = '/';
    private final MailService mailService;
    private final ShareManager shareManager;
    private final NotificationFilterManager notificationFilterManager;
    private final NotificationRecipientUtil notificationRecipientUtil;

    @Autowired
    public ShareSearchEmailsSender(@ComponentImport MailService mailService, @ComponentImport ShareManager shareManager, @ComponentImport NotificationFilterManager notificationFilterManager, NotificationRecipientUtil notificationRecipientUtil) {
        this.mailService = mailService;
        this.shareManager = shareManager;
        this.notificationFilterManager = notificationFilterManager;
        this.notificationRecipientUtil = notificationRecipientUtil;
    }

    public void sendShareSearchEmails(ShareService.ValidateShareSearchRequestResult result, Map<String, Object> params) {
        ApplicationUser from = result.getUser();
        ShareBean shareBean = result.getShareBean();
        SearchRequest searchRequest = result.getSearchRequest();
        List<NotificationRecipient> recipients = this.notificationRecipientUtil.getRecipients(shareBean);
        Iterable<NotificationRecipient> filteredRecipients = this.filterRecipients(recipients);
        for (NotificationRecipient recipient : filteredRecipients) {
            Set<NotificationRecipient> shareRecipients = this.notificationRecipientUtil.filterOutAuthorAndReceiver(from, recipients, recipient);
            this.setSharedWithParamsForRecipient(recipient, shareRecipients, params);
            String template = this.getAppropriateTemplateName(searchRequest, recipient);
            String subjectTemplatePath = SUBJECT_TEMPLATE_PATH + template;
            String bodyTemplatePath = BODY_TEMPLATE_PATH + recipient.getFormat() + '/' + template;
            this.mailService.sendRenderedMail(from, recipient, subjectTemplatePath, bodyTemplatePath, params);
        }
    }

    private Iterable<NotificationRecipient> filterRecipients(List<NotificationRecipient> recipients) {
        final NotificationFilterContext context = this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.SHARED);
        return Iterables.filter(recipients, (Predicate)new Predicate<NotificationRecipient>(){

            public boolean apply(@Nullable NotificationRecipient input) {
                return !ShareSearchEmailsSender.this.notificationFilterManager.filtered(input, context);
            }
        });
    }

    private String getAppropriateTemplateName(SearchRequest searchRequest, NotificationRecipient recipient) {
        boolean userAllowedToSeeSearchResult = this.isUserAllowedToSeeSearchResult(searchRequest, recipient);
        return userAllowedToSeeSearchResult ? SAVED_SEARCH_TEMPLATE : SHARE_JQL_TEMPLATE;
    }

    private boolean isUserAllowedToSeeSearchResult(SearchRequest searchRequest, NotificationRecipient recipient) {
        ApplicationUser userRecipient = recipient.getUser();
        return searchRequest != null && userRecipient != null && this.shareManager.isSharedWith(userRecipient, (SharedEntity)searchRequest);
    }

    private void setSharedWithParamsForRecipient(NotificationRecipient recipient, Set<NotificationRecipient> shareWithRecipients, Map<String, Object> params) {
        params.put("recipient", recipient);
        params.put("involvedUsers", Collections.unmodifiableSet(shareWithRecipients));
    }
}

