/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ShareResource {
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final SearchRequestService searchRequestService;
    private final ShareService shareService;
    private final IssueService issueService;

    @Autowired
    public ShareResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport UserPreferencesManager userPreferencesManager, @ComponentImport SearchRequestService searchRequestService, ShareService shareService, @ComponentImport IssueService issueService) {
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
        this.searchRequestService = searchRequestService;
        this.shareService = shareService;
        this.issueService = issueService;
    }

    @POST
    @Path(value="issue/{key}")
    public Response shareIssue(@PathParam(value="key") String issueKey, ShareBean shareBean) {
        ShareService.ValidateShareIssueResult result;
        ApplicationUser user = this.authenticationContext.getUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        if (!issueResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        Set<String> userNames = shareBean.getUsernames();
        if (user != null && !this.userPreferencesManager.getExtendedPreferences(user).getBoolean("user.notify.own.changes") && userNames.contains(user.getName())) {
            userNames.remove(user.getName());
            shareBean.getEmails().add(user.getEmailAddress());
        }
        if (!(result = this.shareService.validateShareIssue(user, shareBean, (Issue)issueResult.getIssue())).isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareIssue(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="filter/{id}")
    public Response shareSearchRequest(@PathParam(value="id") Long id, ShareBean shareBean) {
        ApplicationUser user = this.authenticationContext.getUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)context, id);
        if (filter == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)context.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        ShareService.ValidateShareSearchRequestResult result = this.shareService.validateShareSearchRequest(user, shareBean, filter);
        if (!result.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareSearchRequest(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="search")
    public Response shareSearch(ShareBean shareBean) {
        ApplicationUser user = this.authenticationContext.getUser();
        ShareService.ValidateShareSearchRequestResult result = this.shareService.validateShareSearchRequest(user, shareBean, null);
        if (!result.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareSearchRequest(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

