/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.plugins.share.event.ShareIssueEvent;
import com.atlassian.jira.plugins.share.issue.NotificationBuilderFactory;
import com.atlassian.jira.plugins.share.util.NotificationRecipientUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShareIssueService {
    private static final Logger log = LoggerFactory.getLogger(ShareIssueService.class);
    private final EventPublisher eventPublisher;
    private final AdhocNotificationService adhocNotificationService;
    private final NotificationBuilderFactory notificationBuilderFactory;
    private final NotificationRecipientUtil notificationRecipientUtil;

    @Autowired
    public ShareIssueService(@ComponentImport EventPublisher eventPublisher, @ComponentImport AdhocNotificationService adhocNotificationService, NotificationBuilderFactory notificationBuilderFactory, NotificationRecipientUtil notificationRecipientUtil) {
        this.eventPublisher = eventPublisher;
        this.adhocNotificationService = adhocNotificationService;
        this.notificationBuilderFactory = notificationBuilderFactory;
        this.notificationRecipientUtil = notificationRecipientUtil;
    }

    public void shareIssue(ShareService.ValidateShareIssueResult result) {
        Issue issue = result.getIssue();
        ApplicationUser from = result.getUser();
        ShareBean shareBean = result.getShareBean();
        this.sendShareIssueEmails(result);
        this.eventPublisher.publish((Object)new ShareIssueEvent(issue, from, shareBean.getUsernames(), shareBean.getEmails(), shareBean.getMessage()));
    }

    private void sendShareIssueEmails(ShareService.ValidateShareIssueResult result) {
        List<NotificationRecipient> recipients = this.notificationRecipientUtil.getRecipients(result.getShareBean());
        for (NotificationRecipient recipient : recipients) {
            this.sendShareIssueMail(result, recipients, recipient);
        }
    }

    private void sendShareIssueMail(ShareService.ValidateShareIssueResult result, List<NotificationRecipient> allRecipients, NotificationRecipient currentRecipient) {
        Set<NotificationRecipient> sharedWithRecipients = this.notificationRecipientUtil.filterOutAuthorAndReceiver(result.getUser(), allRecipients, currentRecipient);
        NotificationBuilder notificationBuilder = this.notificationBuilderFactory.createNotificationBuilder(result.getShareBean().getMessage(), currentRecipient, sharedWithRecipients);
        AdhocNotificationService.ValidateNotificationResult validateNotificationResult = this.adhocNotificationService.validateNotification(notificationBuilder, result.getUser(), result.getIssue(), AdhocNotificationService.ValiationOption.CONTINUE_ON_NO_RECIPIENTS);
        if (validateNotificationResult.isValid()) {
            this.adhocNotificationService.sendNotification(validateNotificationResult);
        } else {
            log.warn("Errors in Notification data: " + validateNotificationResult.getErrorCollection().getErrorMessages());
        }
    }
}

