/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.util;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.components.issueviewer.service.ActionUtilsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class PreferredSearchLayoutService {
    private static final Logger log = Logger.getLogger(PreferredSearchLayoutService.class);
    public static final String LIST_VIEW_LAYOUT = "list-view";
    public static final String PREFERRED_SEARCH_LAYOUT_KEY = "jira.issues.preferred.layout.key";
    public static final String SPLIT_VIEW_LAYOUT = "split-view";
    private final ActionUtilsService actionUtilsService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    @Inject
    public PreferredSearchLayoutService(ActionUtilsService actionUtilsService, JiraAuthenticationContext jiraAuthenticationContext, UserPreferencesManager userPreferencesManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.actionUtilsService = actionUtilsService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = userPreferencesManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    private String getDefaultPreferredSearchLayout() {
        return SPLIT_VIEW_LAYOUT;
    }

    public String getPreferredSearchLayout() {
        String layoutKey;
        Preferences preferences = this.getPreferences();
        if (preferences != null && (layoutKey = preferences.getString(PREFERRED_SEARCH_LAYOUT_KEY)) != null) {
            return layoutKey;
        }
        layoutKey = (String)this.getSession().getAttribute(PREFERRED_SEARCH_LAYOUT_KEY);
        if (layoutKey != null) {
            return layoutKey;
        }
        return this.getDefaultPreferredSearchLayout();
    }

    public void setPreferredSearchLayout(String layoutKey) {
        if (!this.isValidLayoutKey(layoutKey)) {
            throw new IllegalArgumentException("Invalid layout key");
        }
        this.getSession().setAttribute(PREFERRED_SEARCH_LAYOUT_KEY, (Object)layoutKey);
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            try {
                preferences.setString(PREFERRED_SEARCH_LAYOUT_KEY, layoutKey);
            }
            catch (AtlassianCoreException e) {
                log.warn((Object)"Couldn't store a user's preferred search layout in user preferences.");
            }
        }
    }

    private boolean isValidLayoutKey(String layoutKey) {
        return layoutKey.equals(LIST_VIEW_LAYOUT) || layoutKey.equals(SPLIT_VIEW_LAYOUT) || layoutKey.equals(PREFERRED_SEARCH_LAYOUT_KEY);
    }

    private Preferences getPreferences() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user != null) {
            return this.userPreferencesManager.getPreferences(user);
        }
        return null;
    }

    private VelocityRequestSession getSession() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getSession();
    }
}

