/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.plugin.issuenav.rest.SplitViewIssueBean;
import com.atlassian.jira.plugin.issuenav.service.issuetable.AbstractIssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

class SplitViewIssueTableCreator
extends AbstractIssueTableCreator {
    private static final Function<Issue, SplitViewIssueBean> CREATE_ISSUE_BEAN = new Function<Issue, SplitViewIssueBean>(){

        public SplitViewIssueBean apply(@Nullable Issue issue) {
            if (issue == null) {
                return null;
            }
            IssueType issueType = issue.getIssueTypeObject();
            return new SplitViewIssueBean(issue.getId(), issue.getKey(), issue.getStatusObject().getName(), issue.getSummary(), new SplitViewIssueBean.SplitViewIssueTypeBean(issueType.getDescription(), issueType.getName(), issueType.getCompleteIconUrl()));
        }
    };

    public SplitViewIssueTableCreator(ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, IssueTableServiceConfiguration configuration, boolean fromIssueIds, IssueFactory issueFactory, List<Long> issueIds, SortJqlGenerator sortJqlGenerator, Query query, boolean returnIssueIds, SearchHandlerManager searchHandlerManager, SearchProvider searchProvider, SearchProviderFactory searchProviderFactory, SearchRequest searchRequest, SearchService searchService, ApplicationUser user, FieldManager fieldManager, OrderByUtil orderByUtil) {
        super(applicationProperties, columnLayoutManager, configuration, fromIssueIds, issueFactory, issueIds, sortJqlGenerator, query, returnIssueIds, searchHandlerManager, searchProvider, searchProviderFactory, searchRequest, searchService, user, fieldManager, orderByUtil);
    }

    @Override
    protected Object getTable() {
        return Lists.transform((List)this.searchResults.getIssues(), CREATE_ISSUE_BEAN);
    }
}

