/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.components.orderby.SortByBean;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class IssueTable {
    @XmlElement
    private Map<String, String> columnSortJql;
    @XmlElement
    private String description;
    @XmlElement
    private int displayed;
    @XmlElement
    private int end;
    @XmlElement
    private List<Long> issueIds;
    @XmlElement
    private List<String> issueKeys;
    @XmlElement
    private boolean jiraHasIssues;
    @XmlElement
    private int page;
    @XmlElement
    private int pageSize;
    @XmlElement
    private int startIndex;
    @XmlElement
    private Object table;
    @XmlElement
    private String title;
    @XmlElement
    private int total;
    @XmlElement
    private String url;
    @XmlElement
    private SortByBean sortBy;
    @XmlElement
    private List<String> columns;
    @XmlElement
    private String columnConfig;

    private IssueTable() {
    }

    private IssueTable(Builder builder) {
        this.columnSortJql = builder.columnSortJql;
        this.description = builder.description;
        this.displayed = builder.displayed;
        this.end = builder.end;
        this.issueIds = builder.issueIds;
        this.issueKeys = builder.issueKeys;
        this.jiraHasIssues = builder.jiraHasIssues;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.startIndex = builder.startIndex;
        this.sortBy = builder.sortBy;
        this.table = builder.table;
        this.title = builder.title;
        this.total = builder.total;
        this.url = builder.url;
        this.columns = builder.columns;
        this.columnConfig = builder.columnConfig;
    }

    public SortByBean getSortBy() {
        return this.sortBy;
    }

    public int getEnd() {
        return this.end;
    }

    public List<Long> getIssueIds() {
        return this.issueIds;
    }

    public List<String> getIssueKeys() {
        return this.issueKeys;
    }

    public boolean getJiraHasIssues() {
        return this.jiraHasIssues;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public Object getTable() {
        return this.table;
    }

    public int getTotal() {
        return this.total;
    }

    public static class Builder {
        private Map<String, String> columnSortJql;
        private String description = "";
        private int displayed;
        private int end;
        private List<Long> issueIds;
        private List<String> issueKeys;
        private boolean jiraHasIssues;
        private int page;
        private int pageSize;
        private int startIndex;
        private final Object table;
        private String title = "";
        private int total;
        private String url = "";
        private SortByBean sortBy;
        private List<String> columns;
        private String columnConfig;

        public Builder(Object table) {
            this.table = table;
        }

        public IssueTable build() {
            return new IssueTable(this);
        }

        public Builder columnSortJql(Map<String, String> columnSortJql) {
            this.columnSortJql = columnSortJql;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder displayed(int displayed) {
            this.displayed = displayed;
            return this;
        }

        public Builder end(int end) {
            this.end = end;
            return this;
        }

        public Builder issueIds(List<Long> issueIds) {
            this.issueIds = issueIds;
            return this;
        }

        public Builder issueKeys(List<String> issueKeys) {
            this.issueKeys = issueKeys;
            return this;
        }

        public Builder jiraHasIssues(boolean jiraHasIssues) {
            this.jiraHasIssues = jiraHasIssues;
            return this;
        }

        public Builder page(int page) {
            this.page = page;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder total(int total) {
            this.total = total;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder sortBy(SortByBean sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public Builder columnConfig(ColumnLayout.ColumnConfig columnConfig) {
            this.columnConfig = columnConfig.name();
            return this;
        }
    }
}

