/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.TotalHitsAwareCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;

class IssueDocumentAndIdCollector
extends Collector
implements TotalHitsAwareCollector {
    @VisibleForTesting
    static final FieldSelector ID_AND_KEY_FIELD_SELECTOR = new SetBasedFieldSelector((Set)Sets.newHashSet((Object[])new String[]{"issue_id", "key"}), Collections.emptySet());
    protected final IndexSearcher searcher;
    private int docBase;
    private final List<Integer> docIds;
    private final int maximumSize;
    private final int pageSize;
    private final String selectedIssueKey;
    private int startIndex;
    private int documentsCollected = 0;
    private int totalHits = 0;

    public IssueDocumentAndIdCollector(IndexSearcher issuesSearcher, int maximumSize, int pageSize, String selectedIssueKey, int startIndex) {
        this.searcher = issuesSearcher;
        this.docIds = Lists.newArrayListWithCapacity((int)maximumSize);
        this.maximumSize = maximumSize;
        this.pageSize = pageSize;
        this.selectedIssueKey = selectedIssueKey;
        this.startIndex = IssueDocumentAndIdCollector.nearestStartIndex(IssueDocumentAndIdCollector.startIndexWithinMaximumSize(startIndex, maximumSize), pageSize);
    }

    public void collect(int i) {
        if (this.documentsCollected < this.maximumSize) {
            int docid = this.docBase + i;
            this.docIds.add(docid);
        }
        ++this.documentsCollected;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public void setTotalHits(int i) {
        this.totalHits = i;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    private static int nearestStartIndex(int startIndex, int pageSize) {
        return pageSize == 0 ? 0 : startIndex / pageSize * pageSize;
    }

    private static int startIndexWithinMaximumSize(int startIndex, int maximumSize) {
        return maximumSize == 0 ? 0 : Math.min(startIndex, maximumSize - 1);
    }

    public Result computeResult() throws SearchException {
        try {
            int i;
            int pageStartIdx = IssueDocumentAndIdCollector.nearestStartIndex(IssueDocumentAndIdCollector.startIndexWithinMaximumSize(this.startIndex, this.docIds.size()), this.pageSize);
            if (this.selectedIssueKey != null) {
                int selectedDocId;
                int idx;
                TermDocs docs = this.searcher.getIndexReader().termDocs(new Term("key", this.selectedIssueKey));
                if (docs.next() && (idx = this.docIds.indexOf(selectedDocId = docs.doc())) != -1) {
                    pageStartIdx = IssueDocumentAndIdCollector.nearestStartIndex(idx, this.pageSize);
                }
                docs.close();
            }
            ArrayList issueIds = Lists.newArrayListWithCapacity((int)this.docIds.size());
            ArrayList issueKeys = Lists.newArrayListWithCapacity((int)this.docIds.size());
            ArrayList documentsInPage = Lists.newArrayListWithCapacity((int)Math.min(this.pageSize, this.docIds.size()));
            for (int i2 = 0; i2 < pageStartIdx; ++i2) {
                this.addMatch(i2, issueIds, issueKeys);
            }
            int pageEndIdx = Math.min(pageStartIdx + this.pageSize, this.docIds.size());
            for (i = pageStartIdx; i < pageEndIdx; ++i) {
                this.addMatch(i, issueIds, issueKeys, documentsInPage);
            }
            for (i = pageEndIdx; i < this.docIds.size(); ++i) {
                this.addMatch(i, issueIds, issueKeys);
            }
            return new Result(pageStartIdx, this.totalHits, issueIds, issueKeys, documentsInPage);
        }
        catch (IOException e) {
            throw new SearchException((Exception)e);
        }
    }

    private void addMatch(int idx, List<Long> issueIds, List<String> issueKeys) throws IOException {
        Integer docId = this.docIds.get(idx);
        Document doc = this.searcher.doc(docId.intValue(), ID_AND_KEY_FIELD_SELECTOR);
        Long e = Long.valueOf(doc.get("issue_id"));
        issueIds.add(e);
        issueKeys.add(doc.get("key"));
    }

    private void addMatch(int idx, List<Long> issueIds, List<String> issueKeys, List<Document> documents) throws IOException {
        Integer docId = this.docIds.get(idx);
        Document doc = this.searcher.doc(docId.intValue());
        issueIds.add(Long.valueOf(doc.get("issue_id")));
        issueKeys.add(doc.get("key"));
        documents.add(doc);
    }

    public static class Result {
        private final int start;
        private final int total;
        private final List<Long> issueIDs;
        private final List<String> issueKeys;
        private final List<Document> documents;

        private Result(int start, int total, List<Long> issueIDs, List<String> issueKeys, List<Document> documents) {
            this.start = start;
            this.total = total;
            this.issueIDs = issueIDs;
            this.issueKeys = issueKeys;
            this.documents = documents;
        }

        public int getStart() {
            return this.start;
        }

        public int getTotal() {
            return this.total;
        }

        public List<Document> getDocuments() throws SearchException {
            return this.documents;
        }

        public List<Long> getIssueIDs() {
            return this.issueIDs;
        }

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }
    }
}

