/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.plugin.issuenav.service.issuetable.AbstractIssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableCreatorFactory;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.plugin.issuenav.service.issuetable.ListViewIssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.SplitViewIssueTableCreator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultIssueTableCreatorFactory
implements IssueTableCreatorFactory {
    private final ApplicationProperties applicationProperties;
    private final ColumnLayoutManager columnLayoutManager;
    private final IssueFactory issueFactory;
    private final SortJqlGenerator sortJqlGenerator;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory searchProviderFactory;
    private final SearchService searchService;
    private final FieldManager fieldManager;
    private final OrderByUtil orderByUtil;
    private final Map<String, Class<? extends AbstractIssueTableCreator>> issueTableCreators;

    @Inject
    public DefaultIssueTableCreatorFactory(ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, IssueFactory issueFactory, SortJqlGenerator sortJqlGenerator, SearchHandlerManager searchHandlerManager, SearchProvider searchProvider, SearchProviderFactory searchProviderFactory, SearchService searchService, FieldManager fieldManager, OrderByUtil orderByUtil) {
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
        this.issueFactory = issueFactory;
        this.sortJqlGenerator = sortJqlGenerator;
        this.searchHandlerManager = searchHandlerManager;
        this.searchProvider = searchProvider;
        this.searchProviderFactory = searchProviderFactory;
        this.searchService = searchService;
        this.fieldManager = fieldManager;
        this.orderByUtil = orderByUtil;
        this.issueTableCreators = new HashMap<String, Class<? extends AbstractIssueTableCreator>>();
        this.issueTableCreators.put("list-view", ListViewIssueTableCreator.class);
        this.issueTableCreators.put("split-view", SplitViewIssueTableCreator.class);
    }

    DefaultIssueTableCreatorFactory(ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, IssueFactory issueFactory, SortJqlGenerator sortJqlGenerator, SearchHandlerManager searchHandlerManager, SearchProvider searchProvider, SearchProviderFactory searchProviderFactory, SearchService searchService, FieldManager fieldManager, OrderByUtil orderByUtil, Map<String, Class<? extends AbstractIssueTableCreator>> issueTableCreators) {
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
        this.issueFactory = issueFactory;
        this.sortJqlGenerator = sortJqlGenerator;
        this.searchHandlerManager = searchHandlerManager;
        this.searchProvider = searchProvider;
        this.searchProviderFactory = searchProviderFactory;
        this.searchService = searchService;
        this.fieldManager = fieldManager;
        this.orderByUtil = orderByUtil;
        this.issueTableCreators = issueTableCreators;
    }

    @Override
    public AbstractIssueTableCreator getNormalIssueTableCreator(IssueTableServiceConfiguration configuration, Query query, boolean returnIssueIds, SearchRequest searchRequest, ApplicationUser user) {
        return this.createIssueTableCreator(configuration, false, null, query, returnIssueIds, searchRequest, user);
    }

    @Override
    public AbstractIssueTableCreator getStableIssueTableCreator(IssueTableServiceConfiguration configuration, Query query, List<Long> issueIds, SearchRequest searchRequest, ApplicationUser user) {
        return this.createIssueTableCreator(configuration, true, issueIds, query, true, searchRequest, user);
    }

    private AbstractIssueTableCreator createIssueTableCreator(IssueTableServiceConfiguration configuration, boolean fromIssueIds, List<Long> issueIds, Query query, boolean returnIssueIds, SearchRequest searchRequest, ApplicationUser user) {
        Class<? extends AbstractIssueTableCreator> clazz;
        String errorMessage = "Creating an IssueTableCreator failed.";
        String layoutKey = configuration.getLayoutKey();
        try {
            clazz = this.issueTableCreators.get(layoutKey);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid layout key \"" + layoutKey + "\".");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Invalid layout key \"" + layoutKey + "\".");
        }
        try {
            return (AbstractIssueTableCreator)clazz.getConstructors()[0].newInstance(this.applicationProperties, this.columnLayoutManager, configuration, fromIssueIds, this.issueFactory, issueIds, this.sortJqlGenerator, query, returnIssueIds, this.searchHandlerManager, this.searchProvider, this.searchProviderFactory, searchRequest, this.searchService, user, this.fieldManager, this.orderByUtil);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Creating an IssueTableCreator failed.", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Creating an IssueTableCreator failed.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Creating an IssueTableCreator failed.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Creating an IssueTableCreator failed.", e);
        }
    }
}

