/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.orderby.SortByBean;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.issuenav.service.issuetable.DisplayedColumnsHelper;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueDocumentAndIdCollector;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;

abstract class AbstractIssueTableCreator
extends IssueTableCreator {
    private final ApplicationProperties applicationProperties;
    private final DisplayedColumnsHelper searchColumnsFinder;
    private Map<String, String> columnSortJql;
    private SortByBean sortBy;
    final IssueTableServiceConfiguration configuration;
    private final boolean fromIssueIds;
    private final IssueFactory issueFactory;
    private List<Long> issueIds;
    private List<String> issueKeys;
    private final SortJqlGenerator sortJqlGenerator;
    Query query;
    private Query originalQuery;
    private final boolean returnIssueIds;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory searchProviderFactory;
    SearchRequest searchRequest;
    SearchResults searchResults;
    private final SearchService searchService;
    private final ApplicationUser user;
    private final FieldManager fieldManager;
    private OrderByUtil orderByUtil;

    AbstractIssueTableCreator(ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, IssueTableServiceConfiguration configuration, boolean fromIssueIds, IssueFactory issueFactory, List<Long> issueIds, SortJqlGenerator sortJqlGenerator, Query query, boolean returnIssueIds, SearchHandlerManager searchHandlerManager, SearchProvider searchProvider, SearchProviderFactory searchProviderFactory, SearchRequest searchRequest, SearchService searchService, ApplicationUser user, FieldManager fieldManager, OrderByUtil orderByUtil) {
        this.applicationProperties = applicationProperties;
        this.configuration = configuration;
        this.fromIssueIds = fromIssueIds;
        this.issueFactory = issueFactory;
        this.issueIds = issueIds;
        this.sortJqlGenerator = sortJqlGenerator;
        this.query = query;
        this.returnIssueIds = returnIssueIds;
        this.searchHandlerManager = searchHandlerManager;
        this.searchProvider = searchProvider;
        this.searchProviderFactory = searchProviderFactory;
        this.searchRequest = searchRequest;
        this.searchService = searchService;
        this.user = user;
        this.fieldManager = fieldManager;
        this.orderByUtil = orderByUtil;
        this.searchColumnsFinder = new DisplayedColumnsHelper(columnLayoutManager, fieldManager);
        if (fromIssueIds) {
            JqlQueryBuilder queryBuilder = this.getJqlQueryBuilder();
            queryBuilder.where().issue().in(new Operand[]{new MultiValueOperand(issueIds)});
            Query stableSearchQuery = queryBuilder.buildQuery();
            Long filterId = this.searchRequest != null ? this.searchRequest.getId() : null;
            this.searchRequest = new SearchRequest(stableSearchQuery, (ApplicationUser)null, null, null, filterId, 0L);
            this.originalQuery = query == null ? stableSearchQuery : query;
            this.query = stableSearchQuery;
        }
    }

    @VisibleForTesting
    JqlQueryBuilder getJqlQueryBuilder() {
        return JqlQueryBuilder.newBuilder();
    }

    private IssueDocumentAndIdCollector collectIssues(String selectedIssueKey) throws SearchException {
        IndexSearcher issuesSearcher = this.searchProviderFactory.getSearcher("issues");
        IssueDocumentAndIdCollector IDCollector = new IssueDocumentAndIdCollector(issuesSearcher, this.getStableSearchResultsLimit(), this.configuration.getNumberToShow(), selectedIssueKey, this.configuration.getStart());
        this.searchProvider.searchAndSort(this.query, this.user, (Collector)IDCollector, new PagerFilter(0, this.getStableSearchResultsLimit()));
        return IDCollector;
    }

    private List<Issue> convertDocumentsToIssues(List<Document> issueDocuments) {
        ArrayList issues = Lists.newArrayListWithCapacity((int)issueDocuments.size());
        for (Document document : issueDocuments) {
            issues.add(this.issueFactory.getIssue(document));
        }
        return issues;
    }

    @Override
    IssueTable create() throws SearchException {
        ColumnLayout columnLayout = this.getColumnLayout();
        List<ColumnLayoutItem> columns = this.getDisplayedColumns(columnLayout);
        List columnIds = Lists.transform(columns, (Function)ColumnLayoutItem.TO_ID);
        this.configuration.setColumnNames(columnIds);
        if (this.fromIssueIds) {
            this.executeStableSearch(columns);
        } else {
            this.executeNormalSearch(columns);
        }
        return new IssueTable.Builder(this.getTable()).displayed(this.searchResults.getIssues().size()).total(this.searchResults.getTotal()).startIndex(this.searchResults.getStart()).end(this.searchResults.getEnd()).sortBy(this.sortBy).pageSize(this.configuration.getNumberToShow()).columns(this.configuration.getColumnNames()).columnConfig(columnLayout.getColumnConfig()).columnSortJql(this.columnSortJql).jiraHasIssues(this.getJIRAHasIssues()).issueIds(this.fromIssueIds ? null : this.issueIds).issueKeys(this.issueKeys).build();
    }

    private void executeNormalSearch(List<ColumnLayoutItem> columns) throws SearchException {
        this.columnSortJql = this.sortJqlGenerator.generateColumnSortJql(this.query, this.getSortableColumns(columns));
        this.sortBy = this.orderByUtil.generateSortBy(this.query);
        if (this.returnIssueIds) {
            String selectedIssueKey = this.configuration.getSelectedIssueKey();
            IssueDocumentAndIdCollector IDCollector = this.collectIssues(selectedIssueKey);
            IssueDocumentAndIdCollector.Result collectedResult = IDCollector.computeResult();
            this.issueIds = collectedResult.getIssueIDs();
            this.issueKeys = collectedResult.getIssueKeys();
            this.searchResults = new SearchResults(this.convertDocumentsToIssues(collectedResult.getDocuments()), collectedResult.getTotal(), this.configuration.getNumberToShow(), collectedResult.getStart());
        } else {
            PagerFilter pagerFilter = new PagerFilter(this.configuration.getStart(), this.configuration.getNumberToShow());
            this.searchResults = this.searchProvider.search(this.query, this.user, pagerFilter);
            int pageSize = pagerFilter.getPageSize();
            int resultsCount = this.searchResults.getTotal();
            while (pagerFilter.getStart() > 0 && pagerFilter.getStart() >= this.searchResults.getTotal()) {
                pagerFilter.setStart(Math.max(0, resultsCount - 1) / pageSize * pageSize);
                this.searchResults = this.searchProvider.search(this.query, this.user, pagerFilter);
            }
        }
    }

    private void executeStableSearch(List<ColumnLayoutItem> columns) throws SearchException {
        this.columnSortJql = this.sortJqlGenerator.generateColumnSortJql(this.originalQuery, this.getSortableColumns(columns));
        PagerFilter pagerFilter = new PagerFilter(0, this.getStableSearchResultsLimit());
        this.searchResults = this.searchProvider.search(this.query, this.user, pagerFilter);
        HashMap<Long, Issue> issueMap = new HashMap<Long, Issue>();
        for (Issue issue : this.searchResults.getIssues()) {
            issueMap.put(issue.getId(), issue);
        }
        ArrayList sortedIssues = new ArrayList();
        for (Long issueId : this.issueIds) {
            sortedIssues.add(issueMap.get(issueId));
        }
        this.searchResults = new SearchResults(sortedIssues, this.searchResults.getTotal(), pagerFilter);
    }

    protected final List<ColumnLayoutItem> getDisplayedColumns(List<String> columnNames) {
        return this.searchColumnsFinder.getDisplayedColumns(this.user, columnNames).getColumnLayoutItems();
    }

    final List<ColumnLayoutItem> getDisplayedColumns(ColumnLayout columns) {
        return columns.getColumnLayoutItems();
    }

    ColumnLayout getColumnLayout() {
        return this.searchColumnsFinder.getDisplayedColumns(this.user, this.searchRequest, this.configuration);
    }

    private boolean getJIRAHasIssues() throws SearchException {
        if (this.searchResults.getTotal() > 0) {
            return true;
        }
        return this.searchProvider.searchCountOverrideSecurity((Query)new QueryImpl(), this.user) > 0L;
    }

    private int getStableSearchResultsLimit() {
        return Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.search.stable.max.results"));
    }

    private int getStartIndex(List<String> issueKeys) {
        int pageSize = this.configuration.getNumberToShow();
        String selectedIssueKey = this.configuration.getSelectedIssueKey();
        if (selectedIssueKey != null) {
            return Math.max(issueKeys.indexOf(selectedIssueKey), 0) / pageSize * pageSize;
        }
        return this.configuration.getStart();
    }

    abstract Object getTable();

    @Override
    MessageSet validate() {
        if (!this.fromIssueIds) {
            Long filterId = this.searchRequest != null ? this.searchRequest.getId() : null;
            return this.searchService.validateQuery(this.user, this.query, filterId);
        }
        return new MessageSetImpl();
    }

    private List<NavigableField> getSortableColumns(List<ColumnLayoutItem> displayedColumns) {
        ArrayList fields = Lists.newArrayList();
        for (ColumnLayoutItem columnLayoutItem : displayedColumns) {
            fields.add(columnLayoutItem.getNavigableField());
        }
        fields.addAll(this.getOrderByFields());
        return fields;
    }

    private List<NavigableField> getOrderByFields() {
        OrderBy orderBy = this.query.getOrderByClause();
        if (orderBy == null || orderBy.getSearchSorts() == null || orderBy.getSearchSorts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList orderByFields = Lists.newArrayList();
        for (SearchSort sort : orderBy.getSearchSorts()) {
            Collection fieldIds = this.searchHandlerManager.getFieldIds(sort.getField());
            for (String fieldId : fieldIds) {
                Field field = this.fieldManager.getField(fieldId);
                if (!(field instanceof NavigableField)) continue;
                orderByFields.add((NavigableField)field);
            }
        }
        return orderByFields;
    }
}

