/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.rest;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.components.issueviewer.service.SystemFilterService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="issueNav/anonymousAccess")
public class IssueNavAnonymousAccessResource {
    private final IssueService issueService;
    private final SystemFilterService systemFilterService;

    public IssueNavAnonymousAccessResource(IssueService issueService, SystemFilterService systemFilterService) {
        this.issueService = issueService;
        this.systemFilterService = systemFilterService;
    }

    @GET
    @Path(value="{issueKey}")
    @Produces(value={"application/json"})
    public Response hasAccess(@PathParam(value="issueKey") String issueKey, @QueryParam(value="filterId") Long filterId) {
        SystemFilter systemFilter;
        IssueService.IssueResult result = this.issueService.getIssue(null, issueKey);
        if (!result.isValid()) {
            ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)result.getErrorCollection().getReasons());
            if (worstReason == ErrorCollection.Reason.NOT_LOGGED_IN) {
                return IssueNavAnonymousAccessResource.createUnauthorizedResponse();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        if (filterId != null && (systemFilter = this.systemFilterService.getById(filterId)) != null && systemFilter.isRequiresLogin()) {
            return IssueNavAnonymousAccessResource.createUnauthorizedResponse();
        }
        return Response.ok((Object)"{\"accessible\": \"true\"}").cacheControl(CacheControl.never()).build();
    }

    private static Response createUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
    }
}

