/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.action;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.HashMap;
import java.util.Map;

public class MoveIssueLinkAction
extends JiraWebActionSupport
implements OperationContext {
    private final String ISSUE = "issue";
    private final SubTaskManager subTaskManager;
    private final IssueManager issueManager;
    private Long id;
    private Long currentSubTaskSequence;
    private Long subTaskSequence;
    private Boolean disableRedirect;
    private Map<String, Object> viewIssueRenderData;

    public MoveIssueLinkAction(IssueManager issueManager, SubTaskManager subTaskManager) {
        this.issueManager = issueManager;
        this.subTaskManager = subTaskManager;
    }

    public String doMoveIssueLink() throws Exception {
        Long id = this.getId();
        if (id == null) {
            this.log.error((Object)"Cannot move sub-task when no parent issue exists.");
            return this.getError(this.getText("viewissue.error.moveissuelink.no.parent.exist"));
        }
        MutableIssue issue = this.getIssue();
        if (!this.isAllowedReorderSubTasks(issue)) {
            this.getError(this.getText("viewissue.error.moveissuelink.nopermission"));
        }
        if (this.getCurrentSubTaskSequence() == null) {
            this.log.error((Object)"Cannot move sub-task when current sequence is unset.");
            return this.getError(this.getText("viewissue.error.moveissuelink.no.sequence.unset"));
        }
        if (this.getSubTaskSequence() == null) {
            this.log.error((Object)"Cannot move sub-task when sequence is unset.");
            return this.getError(this.getText("viewissue.error.moveissuelink.no.sequence.unset"));
        }
        this.subTaskManager.moveSubTask((Issue)issue, this.getCurrentSubTaskSequence(), this.getSubTaskSequence());
        if (this.getDisableRedirect() != null && this.getDisableRedirect().booleanValue()) {
            return this.getEmptyResponse();
        }
        return this.getRedirect("/browse/" + issue.getKey());
    }

    private String getError(String message) {
        this.viewIssueRenderData = new HashMap<String, Object>();
        this.viewIssueRenderData.put("errorViewIssue", true);
        this.viewIssueRenderData.put("errorType", "viewIssueError");
        this.viewIssueRenderData.put("title", this.getText("viewissue.error.moveissuelink.title"));
        this.viewIssueRenderData.put("body", message);
        this.viewIssueRenderData.put("error", "error");
        return "issue";
    }

    private MutableIssue getIssue() {
        return this.issueManager.getIssueObject(this.getId());
    }

    public boolean isServerRenderedViewIssue() {
        return true;
    }

    public Map<String, Object> getIssueSearchAndViewRenderData() {
        return this.viewIssueRenderData;
    }

    public boolean isAllowedReorderSubTasks(MutableIssue issue) {
        return this.hasIssuePermission(12, (Issue)issue);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCurrentSubTaskSequence() {
        return this.currentSubTaskSequence;
    }

    public void setCurrentSubTaskSequence(Long currentSubTaskSequence) {
        this.currentSubTaskSequence = currentSubTaskSequence;
    }

    public Long getSubTaskSequence() {
        return this.subTaskSequence;
    }

    public void setSubTaskSequence(Long subTaskSequence) {
        this.subTaskSequence = subTaskSequence;
    }

    public Boolean getDisableRedirect() {
        return this.disableRedirect;
    }

    public void setDisableRedirect(Boolean disableRedirect) {
        this.disableRedirect = disableRedirect;
    }

    public Map<String, Object> getFieldValuesHolder() {
        return null;
    }

    public IssueOperation getIssueOperation() {
        return null;
    }
}

