/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.core.filters.AbstractHttpFilter;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LegacyTextQueryUrlRedirectFilter
extends AbstractHttpFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String query = request.getParameter("query");
        if (query != null) {
            query = URLEncoder.encode(query, "UTF-8");
            StringBuffer url = request.getRequestURL();
            if (request.getQueryString() != null) {
                url.append("?").append(request.getQueryString());
            }
            String newUrl = this.transform(url.toString(), query);
            response.sendRedirect(newUrl);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    String transform(String requestURI, String query) {
        String newUri = requestURI.replaceAll("summary=true", "summary=" + query);
        newUri = newUri.replaceAll("description=true", "description=" + query);
        newUri = newUri.replaceAll("environment=true", "environment=" + query);
        newUri = newUri.replaceAll("body=true", "comment=" + query);
        newUri = newUri.replaceAll("query=[^&]*&?", "");
        return newUri;
    }
}

