/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.analytics.api.annotations.Analytics;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.query.util.UserSearchModeService;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.impl.IssueNavigatorActionParams;
import com.atlassian.jira.plugin.issuenav.LegacyUrlToJql;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.UrlBuilder;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class KickassRedirectFilter
extends AbstractHttpFilter {
    private static final Logger log = Logger.getLogger(KickassRedirectFilter.class);
    private final JiraAuthenticationContext authContext;
    private final EventPublisher eventPublisher;
    private final UserSearchModeService userSearchModeService;
    private SearchRequestFactory searchRequestFactory;
    private SearchService searchService;
    private static final Pattern BACKSLASH_OR_DOUBLEQUOTE = Pattern.compile("([\\\\\"])");

    public KickassRedirectFilter(JiraAuthenticationContext authContext, EventPublisher eventPublisher, SearchRequestFactory searchRequestFactory, SearchService searchService, UserSearchModeService userSearchModeService) {
        this.authContext = authContext;
        this.eventPublisher = eventPublisher;
        this.searchRequestFactory = searchRequestFactory;
        this.searchService = searchService;
        this.userSearchModeService = userSearchModeService;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean createNew;
        NavigateToIssueNavigatorEvent navigateToIssueNavigatorEvent = new NavigateToIssueNavigatorEvent();
        navigateToIssueNavigatorEvent.setKickassEnabled(true);
        UrlBuilder redirectUrl = new UrlBuilder("/issues/");
        this.setSearchModeFromPath(request.getServletPath());
        String pagerStart = request.getParameter("pager/start");
        String filterId = request.getParameter("requestId");
        String jqlQuery = request.getParameter("jqlQuery");
        if (jqlQuery == null) {
            jqlQuery = request.getParameter("jql");
        }
        if (createNew = "true".equals(request.getParameter("createNew"))) {
            navigateToIssueNavigatorEvent.setCreateNewSearch(true);
            redirectUrl.addParameter("jql", "");
        } else if (filterId != null) {
            navigateToIssueNavigatorEvent.setSpecifiedFilter(true);
            redirectUrl.addParameter("filter", filterId);
        } else if (jqlQuery != null) {
            navigateToIssueNavigatorEvent.setSpecifiedJql(true);
            redirectUrl.addParameter("jql", jqlQuery);
        } else {
            LegacyUrlToJql lut;
            String searchString = request.getParameter("searchString");
            if ("true".equals(request.getParameter("usedQuickSearch"))) {
                lut = new LegacyUrlToJql(this.authContext, this.searchService, this.searchRequestFactory);
                String jql = lut.apply((ActionParams)new IssueNavigatorActionParams(request.getParameterMap()));
                redirectUrl.addParameterUnsafe("jql", this.encodeRight(jql)).addParameterUnsafe("quickSearchQuery", this.encodeRight(searchString));
                navigateToIssueNavigatorEvent.setUsedQuickSearch(true);
                navigateToIssueNavigatorEvent.setUsedSmartQuery(true);
            } else if (searchString != null) {
                String cleanQuery = "";
                if (!StringUtils.isBlank((String)searchString)) {
                    cleanQuery = this.jqlEncode(searchString);
                    cleanQuery = this.encodeRight("text ~ \"" + cleanQuery + "\"");
                }
                redirectUrl.addParameterUnsafe("jql", cleanQuery);
                navigateToIssueNavigatorEvent.setUsedQuickSearch(true);
            } else {
                lut = new LegacyUrlToJql(this.authContext, this.searchService, this.searchRequestFactory);
                String jql = lut.apply((ActionParams)new IssueNavigatorActionParams(request.getParameterMap()));
                if (StringUtils.isBlank((String)jql)) {
                    redirectUrl.addParameter("redirectedFromClassic", "");
                } else {
                    redirectUrl.addParameterUnsafe("jql", this.encodeRight(jql));
                    navigateToIssueNavigatorEvent.setUsedLegacyUrl(true);
                }
            }
        }
        if (!StringUtils.isBlank((String)pagerStart)) {
            redirectUrl.addParameter("startIndex", pagerStart);
        }
        String redirectLocation = redirectUrl.toString();
        if (navigateToIssueNavigatorEvent.isUsedQuickSearch()) {
            RequestDispatcher dispatcher = request.getRequestDispatcher(redirectLocation);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(request.getContextPath() + redirectLocation);
        }
        this.eventPublisher.publish((Object)navigateToIssueNavigatorEvent);
    }

    private void setSearchModeFromPath(String path) {
        if (path.contains("executeAdvanced.jspa")) {
            this.userSearchModeService.setSearchMode("advanced");
        }
    }

    private String jqlEncode(String searchString) {
        if (StringUtils.isBlank((String)searchString)) {
            return "";
        }
        return BACKSLASH_OR_DOUBLEQUOTE.matcher(searchString.trim()).replaceAll("\\\\$1");
    }

    private String encodeRight(String urlEncodeMe) {
        if (StringUtils.isBlank((String)urlEncodeMe)) {
            return "";
        }
        return JiraUrlCodec.encode((String)urlEncodeMe).replaceAll("\\+", "%20");
    }

    @Analytics(value="kickass.navigateToIssueNavigator")
    public static class NavigateToIssueNavigatorEvent {
        private boolean kickassEnabled = false;
        private boolean usedQuickSearch = false;
        private boolean usedSmartQuery = false;
        private boolean createNewSearch = false;
        private boolean specifiedJql = false;
        private boolean specifiedFilter = false;
        private boolean usedLegacyUrl;

        public boolean isKickassEnabled() {
            return this.kickassEnabled;
        }

        public void setKickassEnabled(boolean kickassEnabled) {
            this.kickassEnabled = kickassEnabled;
        }

        public boolean isUsedQuickSearch() {
            return this.usedQuickSearch;
        }

        public void setUsedQuickSearch(boolean usedQuickSearch) {
            this.usedQuickSearch = usedQuickSearch;
        }

        public boolean isUsedSmartQuery() {
            return this.usedSmartQuery;
        }

        public void setUsedSmartQuery(boolean usedSmartQuery) {
            this.usedSmartQuery = usedSmartQuery;
        }

        public boolean isCreateNewSearch() {
            return this.createNewSearch;
        }

        public void setCreateNewSearch(boolean createNewSearch) {
            this.createNewSearch = createNewSearch;
        }

        public boolean isSpecifiedJql() {
            return this.specifiedJql;
        }

        public void setSpecifiedJql(boolean specifiedJql) {
            this.specifiedJql = specifiedJql;
        }

        public boolean isSpecifiedFilter() {
            return this.specifiedFilter;
        }

        public void setSpecifiedFilter(boolean specifiedFilter) {
            this.specifiedFilter = specifiedFilter;
        }

        public boolean isUsedLegacyUrl() {
            return this.usedLegacyUrl;
        }

        public void setUsedLegacyUrl(boolean usedLegacyUrl) {
            this.usedLegacyUrl = usedLegacyUrl;
        }
    }
}

