/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.fugue;

import io.atlassian.fugue.Checked;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Try<A> {
    public static <A> Try<A> failure(Exception e) {
        return new Failure(e);
    }

    public static <A> Try<A> successful(A value) {
        return new Success<A>(value);
    }

    public static <A> Try<Iterable<A>> sequence(Iterable<Try<A>> trys) {
        ArrayList<Object> ts = new ArrayList<Object>();
        for (Try<Object> try_ : trys) {
            if (try_.isFailure()) {
                return new Failure<Iterable<A>>(try_.fold(Function.identity(), x -> {
                    throw new NoSuchElementException();
                }));
            }
            ts.add(try_.fold(f -> {
                throw new NoSuchElementException();
            }, Function.identity()));
        }
        return new Success<Iterable<A>>(Collections.unmodifiableList(ts));
    }

    public static <A> Try<A> flatten(Try<Try<A>> t) {
        return t.flatMap(Function.identity());
    }

    public abstract boolean isFailure();

    public abstract boolean isSuccess();

    public abstract <B> Try<B> flatMap(Function<? super A, Try<B>> var1);

    public abstract <B> Try<B> map(Function<? super A, ? extends B> var1);

    public abstract Try<A> recover(Function<? super Exception, A> var1);

    public abstract Try<A> recoverWith(Function<? super Exception, Try<A>> var1);

    public abstract A getOrElse(Supplier<A> var1);

    public abstract <B> B fold(Function<? super Exception, B> var1, Function<A, B> var2);

    public abstract Either<Exception, A> toEither();

    public abstract Option<A> toOption();

    private static final class Success<A>
    extends Try<A> {
        private final A value;

        Success(A value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <B> Try<B> map(Function<? super A, ? extends B> f) {
            return Checked.of(() -> f.apply((A)this.value));
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public <B> Try<B> flatMap(Function<? super A, Try<B>> f) {
            return f.apply(this.value);
        }

        @Override
        public Try<A> recover(Function<? super Exception, A> f) {
            return this;
        }

        @Override
        public Try<A> recoverWith(Function<? super Exception, Try<A>> f) {
            return this;
        }

        @Override
        public A getOrElse(Supplier<A> s) {
            return this.value;
        }

        @Override
        public <B> B fold(Function<? super Exception, B> failureF, Function<A, B> successF) {
            return successF.apply(this.value);
        }

        @Override
        public Either<Exception, A> toEither() {
            return Either.right(this.value);
        }

        @Override
        public Option<A> toOption() {
            return Option.some(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return this.value != null ? this.value.equals(success.value) : success.value == null;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class Failure<A>
    extends Try<A> {
        private final Exception e;

        Failure(Exception e) {
            this.e = Objects.requireNonNull(e);
        }

        @Override
        public <B> Try<B> map(Function<? super A, ? extends B> f) {
            return new Failure<A>(this.e);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public <B> Try<B> flatMap(Function<? super A, Try<B>> f) {
            return Try.failure(this.e);
        }

        @Override
        public Try<A> recover(Function<? super Exception, A> f) {
            return Checked.of(() -> f.apply(this.e));
        }

        @Override
        public Try<A> recoverWith(Function<? super Exception, Try<A>> f) {
            return f.apply(this.e);
        }

        @Override
        public A getOrElse(Supplier<A> s) {
            return s.get();
        }

        @Override
        public <B> B fold(Function<? super Exception, B> failureF, Function<A, B> successF) {
            return failureF.apply(this.e);
        }

        @Override
        public Either<Exception, A> toEither() {
            return Either.left(this.e);
        }

        @Override
        public Option<A> toOption() {
            return Option.none();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure = (Failure)o;
            return this.e != null ? this.e.equals(failure.e) : failure.e == null;
        }

        public int hashCode() {
            return ~this.e.hashCode();
        }
    }
}

