/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.matcher;

import com.atlassian.plugins.whitelist.matcher.MatcherUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.net.URISyntaxException;

public class DomainNameMatcher
implements Predicate<URI> {
    private final String expression;

    public DomainNameMatcher(String expression) {
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
    }

    public boolean apply(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return this.expression.equalsIgnoreCase(normalizedUri.getScheme() + "://" + normalizedUri.getAuthority());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

