/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.instrumentation.PluginSystemInstrumentation;
import com.atlassian.plugin.instrumentation.Timer;
import com.atlassian.plugin.manager.ForwardingPluginAccessor;
import com.atlassian.plugin.manager.SafeModuleExtractor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class EnabledModuleCachingPluginAccessor
extends ForwardingPluginAccessor
implements PluginAccessor {
    private static final long DESCRIPTOR_TIMEOUT_SEC = Long.getLong("com.atlassian.plugin.descriptor.class.cache.timeout.sec", 1800L);
    private static final long MODULE_TIMEOUT_SEC = Long.getLong("com.atlassian.plugin.module.class.cache.timeout.sec", 1800L);
    private final SafeModuleExtractor safeModuleExtractor;
    private final LoadingCache<Class<ModuleDescriptor<Object>>, List<ModuleDescriptor<Object>>> cacheByDescriptorClass = CacheBuilder.newBuilder().expireAfterAccess(DESCRIPTOR_TIMEOUT_SEC, TimeUnit.SECONDS).build(CacheLoader.from((Function)new ByModuleDescriptorClassCacheLoader()));
    private final LoadingCache<Class<?>, List<ModuleDescriptor<Object>>> cacheByModuleClass = CacheBuilder.newBuilder().expireAfterAccess(MODULE_TIMEOUT_SEC, TimeUnit.SECONDS).build(CacheLoader.from((Function)new ByModuleClassCacheLoader()));

    public EnabledModuleCachingPluginAccessor(PluginAccessor delegate, PluginEventManager pluginEventManager, PluginController pluginController) {
        super(delegate);
        Preconditions.checkNotNull((Object)pluginEventManager);
        this.safeModuleExtractor = new SafeModuleExtractor(pluginController);
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisable(PluginDisabledEvent event) {
        this.invalidateAll();
    }

    @PluginEventListener
    public void onPluginEnable(PluginEnabledEvent event) {
        this.invalidateAll();
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.invalidateAll();
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.invalidateAll();
    }

    @PluginEventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        this.invalidateAll();
    }

    private void invalidateAll() {
        this.cacheByDescriptorClass.invalidateAll();
        this.cacheByModuleClass.invalidateAll();
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        try (Timer ignored = PluginSystemInstrumentation.instance().pullTimer("getEnabledModuleDescriptorsByClass");){
            List descriptors;
            List list = descriptors = (List)this.cacheByDescriptorClass.getUnchecked(descriptorClazz);
            return list;
        }
    }

    @Override
    public <M> List<M> getEnabledModulesByClass(Class<M> moduleClass) {
        try (Timer ignored = PluginSystemInstrumentation.instance().pullTimer("getEnabledModulesByClass");){
            ImmutableList immutableList = ImmutableList.copyOf(this.safeModuleExtractor.getModules((Iterable)this.cacheByModuleClass.getUnchecked(moduleClass)));
            return immutableList;
        }
    }

    private <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByModuleClass(Class<M> moduleClass) {
        final ModuleOfClassPredicate<M> ofType = new ModuleOfClassPredicate<M>(moduleClass);
        final EnabledModulePredicate enabled = new EnabledModulePredicate();
        return ImmutableList.copyOf(this.getModuleDescriptors(this.delegate.getEnabledPlugins(), new ModuleDescriptorPredicate<M>(){

            public boolean matches(ModuleDescriptor<? extends M> moduleDescriptor) {
                return ofType.matches(moduleDescriptor) && enabled.matches(moduleDescriptor);
            }
        }));
    }

    private <M> Iterable<ModuleDescriptor<M>> getModuleDescriptors(Collection<Plugin> plugins, final ModuleDescriptorPredicate<M> predicate) {
        final Function coercer = new Function<ModuleDescriptor<?>, ModuleDescriptor<M>>(){

            public ModuleDescriptor<M> apply(ModuleDescriptor<?> input) {
                ModuleDescriptor<?> result = input;
                return result;
            }
        };
        final Predicate adapter = new Predicate<ModuleDescriptor<M>>(){

            public boolean apply(ModuleDescriptor<M> input) {
                return predicate.matches(input);
            }
        };
        Function descriptorExtractor = new Function<Plugin, Iterable<ModuleDescriptor<M>>>(){

            public Iterable<ModuleDescriptor<M>> apply(Plugin plugin) {
                return Iterables.filter((Iterable)Iterables.transform((Iterable)plugin.getModuleDescriptors(), (Function)coercer), (Predicate)adapter);
            }
        };
        return Iterables.concat((Iterable)Iterables.transform(plugins, (Function)descriptorExtractor));
    }

    private class ByModuleClassCacheLoader
    implements Function<Class, List<ModuleDescriptor<Object>>> {
        private ByModuleClassCacheLoader() {
        }

        public List<ModuleDescriptor<Object>> apply(Class moduleClass) {
            return EnabledModuleCachingPluginAccessor.this.getEnabledModuleDescriptorsByModuleClass(moduleClass);
        }
    }

    private class ByModuleDescriptorClassCacheLoader
    implements Function<Class<ModuleDescriptor<Object>>, List<ModuleDescriptor<Object>>> {
        private ByModuleDescriptorClassCacheLoader() {
        }

        public List<ModuleDescriptor<Object>> apply(Class<ModuleDescriptor<Object>> moduleDescriptorClass) {
            return EnabledModuleCachingPluginAccessor.this.delegate.getEnabledModuleDescriptorsByClass(moduleDescriptorClass);
        }
    }
}

