/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.instrumentation;

import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.plugin.instrumentation.Timer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTimer
extends Timer {
    private static final Logger log = LoggerFactory.getLogger(SingleTimer.class);
    private String name;

    SingleTimer(@Nonnull Optional<OpTimer> opTimer, String name) {
        super(opTimer);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        Optional<OpTimer> timerOption = this.getOpTimer();
        if (timerOption.isPresent()) {
            OpSnapshot snapshot = timerOption.get().snapshot();
            long cpuTime = snapshot.getCpuTotalTime(TimeUnit.MILLISECONDS);
            long elapsedTime = snapshot.getElapsedTotalTime(TimeUnit.MILLISECONDS);
            String logKey = "com.atlassian.plugin." + this.name;
            String cpuKey = logKey + ".cpu-ms";
            String clockKey = logKey + ".clock-ms";
            MDC.put((String)cpuKey, (Object)cpuTime);
            MDC.put((String)clockKey, (Object)elapsedTime);
            log.info("Timer {} took {}ms ({} cpu ns)", new Object[]{snapshot.getName(), elapsedTime, cpuTime});
            MDC.remove((String)clockKey);
            MDC.remove((String)cpuKey);
        }
        super.close();
    }
}

