/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.util;

import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultSortJqlGenerator
implements SortJqlGenerator {
    private final JqlStringSupport jqlStringSupport;
    private final SearchHandlerManager searchHandlerManager;

    @Inject
    public DefaultSortJqlGenerator(JqlStringSupport jqlStringSupport, SearchHandlerManager searchHandlerManager) {
        this.jqlStringSupport = jqlStringSupport;
        this.searchHandlerManager = searchHandlerManager;
    }

    @Override
    @VisibleForTesting
    public Map<String, String> generateColumnSortJql(Query query, List<NavigableField> fields) {
        HashMap<String, String> columnSortJql = new HashMap<String, String>();
        for (NavigableField field : fields) {
            OrderBy orderBy = this.buildOrderBy(query.getOrderByClause(), field);
            columnSortJql.put(field.getId(), this.jqlStringSupport.generateJqlString((Query)new QueryImpl(query.getWhereClause(), orderBy, null)));
        }
        return columnSortJql;
    }

    private OrderBy buildOrderBy(OrderBy orderBy, NavigableField field) {
        String columnName;
        SortOrder columnDirection = SortOrder.parseString((String)field.getDefaultSortOrder());
        boolean isCustomField = field instanceof CustomField;
        if (isCustomField) {
            CustomField customField = (CustomField)field;
            columnName = JqlCustomFieldId.toString((long)customField.getIdAsLong());
        } else {
            Collection jqlClauseNames = this.searchHandlerManager.getJqlClauseNames(field.getId());
            columnName = !jqlClauseNames.isEmpty() ? ((ClauseNames)jqlClauseNames.iterator().next()).getPrimaryName() : field.getId();
        }
        ArrayList<SearchSort> searchSorts = new ArrayList<SearchSort>();
        for (SearchSort searchSort : orderBy.getSearchSorts()) {
            String fieldInSearch = searchSort.getField();
            if (fieldInSearch.equals(columnName) || !isCustomField && this.isAlias(field.getId(), fieldInSearch) || isCustomField && ((CustomField)field).getUntranslatedName().equals(fieldInSearch)) {
                columnName = fieldInSearch;
                SortOrder sortOrder = searchSort.getSortOrder();
                if (sortOrder == null) {
                    sortOrder = SortOrder.parseString((String)field.getDefaultSortOrder());
                }
                if (sortOrder == SortOrder.ASC) {
                    columnDirection = SortOrder.DESC;
                    continue;
                }
                columnDirection = SortOrder.ASC;
                continue;
            }
            searchSorts.add(searchSort);
        }
        searchSorts.add(0, new SearchSort(columnName, columnDirection));
        return new OrderByImpl(searchSorts);
    }

    private boolean isAlias(String fieldId, String columnName) {
        ClauseInformation clauseInformation = SystemSearchConstants.getClauseInformationById((String)fieldId);
        return clauseInformation != null && clauseInformation.getJqlClauseNames().contains(columnName);
    }
}

