/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query.util;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.components.query.util.UserSearchModeService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@ExportAsService
@Named
public class DefaultUserSearchModeService
implements UserSearchModeService {
    private static final Logger log = Logger.getLogger(DefaultUserSearchModeService.class);
    private static final String SEARCH_MODE_KEY = "user.search.mode";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    @Inject
    public DefaultUserSearchModeService(JiraAuthenticationContext jiraAuthenticationContext, UserPreferencesManager userPreferencesManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = userPreferencesManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    public String getSearchMode() {
        String searchMode = (String)this.getSession().getAttribute(SEARCH_MODE_KEY);
        if (searchMode != null) {
            return searchMode;
        }
        Preferences preferences = this.getPreferences();
        if (preferences != null && (searchMode = preferences.getString(SEARCH_MODE_KEY)) != null) {
            return searchMode;
        }
        return "basic";
    }

    @Override
    public void setSearchMode(String searchMode) {
        if (!searchMode.equals("advanced") && !searchMode.equals("basic")) {
            throw new IllegalArgumentException(searchMode + "is not a valid search mode.");
        }
        this.getSession().setAttribute(SEARCH_MODE_KEY, (Object)searchMode);
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            try {
                preferences.setString(SEARCH_MODE_KEY, searchMode);
            }
            catch (AtlassianCoreException e) {
                log.warn((Object)"Couldn't store a user's preferred search mode in user preferences.");
            }
        }
    }

    private Preferences getPreferences() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user != null) {
            return this.userPreferencesManager.getPreferences(user);
        }
        return null;
    }

    private VelocityRequestSession getSession() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getSession();
    }
}

