/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query.rest;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="jqlAutoComplete")
public class JqlAutoCompleteResource {
    private AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public JqlAutoCompleteResource(AutoCompleteJsonGenerator autoCompleteJsonGenerator, JiraAuthenticationContext jiraAuthenticationContext) {
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    public Response get() throws JSONException {
        return Response.ok((Object)this.getJqlAutoCompleteJson()).cacheControl(CacheControl.never()).build();
    }

    private String getJqlAutoCompleteJson() throws JSONException {
        HashMap jqlAutoCompleteJson = Maps.newHashMap();
        jqlAutoCompleteJson.put("jqlFieldz", this.getVisibleFieldNamesJson());
        jqlAutoCompleteJson.put("jqlFunctionNamez", this.getVisibleFunctionNamesJson());
        jqlAutoCompleteJson.put("jqlReservedWordz", this.getJqlReservedWordsJson());
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal((Object)jqlAutoCompleteJson);
    }

    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale());
    }

    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale());
    }

    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }
}

