/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.query.SearchContextHelper;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@ExportAsService
@Named
public class DefaultSearchContextHelper
implements SearchContextHelper {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchService searchService;
    private final IssueSearcherManager issueSearcherManager;

    @Inject
    public DefaultSearchContextHelper(JiraAuthenticationContext authenticationContext, SearchService searchService, IssueSearcherManager issueSearcherManager) {
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.issueSearcherManager = issueSearcherManager;
    }

    @Override
    public SearchContextHelper.SearchContextWithFieldValues getSearchContextWithFieldValuesFromJqlString(String query) {
        SearchService.ParseResult jqlQuery;
        if (StringUtils.isNotBlank((String)query) && (jqlQuery = this.searchService.parseQuery(this.getLoggedInUser(), query)).isValid()) {
            SearchContext searchContext = this.searchService.getSearchContext(this.getLoggedInUser(), jqlQuery.getQuery());
            return this.getSearchContextWithFieldValuesFromQuery(searchContext, jqlQuery.getQuery());
        }
        return new SearchContextHelper.SearchContextWithFieldValues(this.createSearchContext(), (FieldValuesHolder)new FieldValuesHolderImpl());
    }

    @Override
    public SearchContextHelper.SearchContextWithFieldValues getSearchContextWithFieldValuesFromQuery(SearchContext searchContext, Query query) {
        FieldValuesHolder fieldValuesHolder = this.createFieldValuesHolderFromQuery(query, searchContext);
        return new SearchContextHelper.SearchContextWithFieldValues(searchContext, fieldValuesHolder);
    }

    @Override
    public SearchContext getSearchContextFromJqlString(String query) {
        SearchService.ParseResult jqlQuery;
        if (StringUtils.isNotBlank((String)query) && (jqlQuery = this.searchService.parseQuery(this.getLoggedInUser(), query)).isValid()) {
            return this.searchService.getSearchContext(this.getLoggedInUser(), jqlQuery.getQuery());
        }
        return this.createSearchContext();
    }

    private FieldValuesHolder createFieldValuesHolderFromQuery(Query query, SearchContext searchContext) {
        FieldValuesHolderImpl fieldValuesHolder = new FieldValuesHolderImpl();
        for (IssueSearcher searcher : this.issueSearcherManager.getAllSearchers()) {
            searcher.getSearchInputTransformer().populateFromQuery(this.getLoggedInUser(), (FieldValuesHolder)fieldValuesHolder, query, searchContext);
        }
        return fieldValuesHolder;
    }

    private SearchContext createSearchContext() {
        return new SearchContextImpl(Collections.emptyList(), null, null);
    }

    private ApplicationUser getLoggedInUser() {
        return this.authenticationContext.getLoggedInUser();
    }
}

