/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.query;

import com.atlassian.jira.components.query.RecentSearchersService;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueSearcherHistoryManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultRecentSearchersService
implements RecentSearchersService {
    private UserIssueSearcherHistoryManager userIssueSearcherHistoryManager;

    @Inject
    public DefaultRecentSearchersService(UserIssueSearcherHistoryManager userIssueSearcherHistoryManager) {
        this.userIssueSearcherHistoryManager = userIssueSearcherHistoryManager;
    }

    @Override
    public Map<String, Long> getRecentSearchers(ApplicationUser user) {
        return this.userIssueSearcherHistoryManager.getUserIssueSearcherHistory(user).stream().collect(Collectors.toMap(UserHistoryItem::getEntityId, UserHistoryItem::getLastViewed, (lastViewed1, lastViewed2) -> lastViewed1));
    }

    @Override
    public void addRecentSearcher(ApplicationUser user, IssueSearcher<?> issueSearcher) {
        this.userIssueSearcherHistoryManager.addIssueSearcherToHistory(user, issueSearcher);
    }
}

