/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.viewissue.webpanel;

import com.atlassian.jira.rest.v2.issue.LinkGroupBean;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class WebPanelBean {
    @XmlElement
    private String completeKey;
    @XmlElement
    private String prefix;
    @XmlElement
    private String id;
    @XmlElement
    private String styleClass;
    @XmlElement
    private String label;
    @XmlElement
    private boolean renderHeader;
    @XmlElement
    private LinkGroupBean headerLinks;
    @XmlElement
    private List<String> subpanelHtmls;
    @XmlElement
    private String html;
    @XmlElement
    private Integer weight;
    @XmlElement
    private String contentId;

    WebPanelBean() {
    }

    private WebPanelBean(String completeKey, String prefix, String id, String styleClass, String label, boolean renderHeader, LinkGroupBean headerLinks, List<String> subpanelHtmls, String html, Integer weight) {
        this.completeKey = completeKey;
        this.prefix = prefix;
        this.id = id;
        this.styleClass = styleClass;
        this.label = label;
        this.renderHeader = renderHeader;
        this.headerLinks = headerLinks;
        this.subpanelHtmls = subpanelHtmls;
        this.html = html;
        this.weight = weight;
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getId() {
        return this.id;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRenderHeader() {
        return this.renderHeader;
    }

    public LinkGroupBean getHeaderLinks() {
        return this.headerLinks;
    }

    public List<String> getSubpanelHtmls() {
        return this.subpanelHtmls;
    }

    public String getHtml() {
        return this.html;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebPanelBean that = (WebPanelBean)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.completeKey != null ? !this.completeKey.equals(that.completeKey) : that.completeKey != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        if (this.styleClass != null ? !this.styleClass.equals(that.styleClass) : that.styleClass != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.renderHeader != that.renderHeader) {
            return false;
        }
        if (this.html != null ? !this.html.equals(that.html) : that.html != null) {
            return false;
        }
        return !(this.weight != null ? !this.weight.equals(that.weight) : that.weight != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.completeKey != null ? this.completeKey.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.styleClass != null ? this.styleClass.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.renderHeader ? 1 : 0);
        result = 31 * result + (this.html != null ? this.html.hashCode() : 0);
        result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String completeKey;
        private String prefix;
        private String id;
        private String styleClass;
        private String label;
        private boolean renderHeader;
        private LinkGroupBean headerLinks;
        private List<String> subpanelHtmls;
        private String html;
        private Integer weight;

        public Builder() {
        }

        public Builder(WebPanelBean panel) {
            this.completeKey = panel.getCompleteKey();
            this.prefix = panel.getPrefix();
            this.id = panel.getId();
            this.styleClass = panel.getStyleClass();
            this.label = panel.getLabel();
            this.renderHeader = panel.isRenderHeader();
            this.headerLinks = panel.getHeaderLinks();
            this.subpanelHtmls = panel.getSubpanelHtmls();
            this.weight = panel.getWeight();
            this.html = panel.getHtml();
        }

        public Builder completeKey(String completeKey) {
            this.completeKey = completeKey;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder styleClass(String styleClass) {
            this.styleClass = styleClass;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder renderHeader(boolean renderHeader) {
            this.renderHeader = renderHeader;
            return this;
        }

        public Builder headerLinks(LinkGroupBean headerLinks) {
            this.headerLinks = headerLinks;
            return this;
        }

        public Builder subpanelHtmls(List<String> subpanelHtmls) {
            this.subpanelHtmls = subpanelHtmls;
            return this;
        }

        public Builder html(String html) {
            this.html = html;
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public WebPanelBean build() {
            return new WebPanelBean(this.completeKey, this.prefix, this.id, this.styleClass, this.label, this.renderHeader, this.headerLinks, this.subpanelHtmls, this.html, this.weight);
        }
    }
}

