/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.service;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.issueviewer.service.SessionSearchService;
import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.components.issueviewer.service.SystemFilterService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

@ExportAsService
@Named
public class DefaultSessionSearchService
implements SessionSearchService {
    private final JiraAuthenticationContext authenticationContext;
    private final SystemFilterService systemFilterService;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;

    @Inject
    public DefaultSessionSearchService(ApplicationProperties applicationProperties, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory, SearchRequestService searchRequestService, SearchService searchService, JiraAuthenticationContext authenticationContext, SystemFilterService systemFilterService) {
        this.authenticationContext = authenticationContext;
        this.systemFilterService = systemFilterService;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
    }

    @Override
    public PagerFilter getPagerFilter() {
        return (PagerFilter)this.getPagerFilterManager().getCurrentObject();
    }

    @Override
    public SearchRequest getSessionSearch() {
        HttpServletRequest request = ActionContext.getRequest();
        SearchRequest searchRequest = (SearchRequest)this.sessionSearchObjectManagerFactory.createSearchRequestManager(request).getCurrentObject();
        if (searchRequest != null && searchRequest.isLoaded()) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser(), (ErrorCollection)errorCollection);
            SearchRequest databaseSearchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, searchRequest.getId());
            if (databaseSearchRequest != null) {
                if (searchRequest.isModified()) {
                    searchRequest.setPermissions(databaseSearchRequest.getPermissions());
                } else {
                    databaseSearchRequest.setUseColumns(searchRequest.useColumns());
                    searchRequest = databaseSearchRequest;
                }
            }
        }
        return searchRequest;
    }

    @Override
    public void setSessionSearch(String jql, Long filterId, int startIndex, int max) {
        SessionSearchRequestManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createSearchRequestManager();
        SearchRequest sessionSearchRequest = null;
        if (filterId != null) {
            if (SystemFilter.isSystemFilter(filterId)) {
                SystemFilter systemFilter = this.systemFilterService.getById(filterId);
                sessionSearchRequest = new SearchRequest(this.searchService.parseQuery(null, SystemFilter.getSystemFilterById(filterId).getJql()).getQuery(), null, this.authenticationContext.getI18nHelper().getText(systemFilter.getName()), null, filterId, 0L){

                    public boolean isLoaded() {
                        return super.isLoaded() && !SystemFilter.isSystemFilter(this.getId());
                    }
                };
            } else {
                sessionSearchRequest = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser()), filterId);
            }
        }
        if (jql != null) {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
            if (!parseResult.isValid()) {
                return;
            }
            Query query = parseResult.getQuery();
            if (sessionSearchRequest == null) {
                sessionSearchRequest = new SearchRequest(query);
            } else if (!query.equals(sessionSearchRequest.getQuery())) {
                sessionSearchRequest.setQuery(query);
            }
        }
        sessionSearchRequestManager.setCurrentObject(sessionSearchRequest);
        SessionPagerFilterManager sessionPagerFilterManager = this.getPagerFilterManager();
        PagerFilter pager = (PagerFilter)this.getPagerFilterManager().getCurrentObject();
        if (null == pager) {
            pager = new PagerFilter(startIndex, max);
            sessionPagerFilterManager.setCurrentObject((Object)pager);
        } else {
            pager.setStart(startIndex);
            pager.setMax(max);
        }
    }

    private SessionPagerFilterManager getPagerFilterManager() {
        return this.sessionSearchObjectManagerFactory.createPagerFilterManager();
    }
}

