/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.components.issueviewer.service;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.components.issueviewer.service.ActionUtilsService;
import com.atlassian.jira.components.issueviewer.service.SystemFilterService;
import com.atlassian.jira.components.issueviewer.util.HashTransformer;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

@ExportAsService
@Named
public class ActionUtilsServiceImpl
implements ActionUtilsService {
    private static final Logger log = Logger.getLogger(ActionUtilsServiceImpl.class);
    public static final String JIRA_OPTION_DISABLE_INLINE_EDIT = "jira.issue.inline.edit.disabled";
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final FeatureManager featureManager;
    private final HashTransformer hashTransformer;
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final SystemFilterService systemFilterService;
    private static final List<String> QUERY_PARAMETERS = Lists.newArrayList((Object[])new String[]{"jql", "filter", "startIndex", "page"});
    private final ApplicationProperties applicationProperties;

    @Inject
    public ActionUtilsServiceImpl(IssueService issueService, JiraAuthenticationContext jiraAuthenticationContext, SystemFilterService systemFilterService, FeatureManager featureManager, AutoCompleteJsonGenerator autoCompleteJsonGenerator, SoyTemplateRenderer soyTemplateRenderer, ApplicationProperties applicationProperties) {
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.featureManager = featureManager;
        this.applicationProperties = applicationProperties;
        this.hashTransformer = new HashTransformer();
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.systemFilterService = systemFilterService;
    }

    @Override
    public String getUserAgent(HttpServletRequest request) {
        return request.getHeader("USER-AGENT");
    }

    @Override
    public boolean isInlineEditEnabled() {
        return !this.applicationProperties.getOption(JIRA_OPTION_DISABLE_INLINE_EDIT);
    }

    @Override
    public boolean noGlobalShortcutLinksIsEnabled() {
        return IssueNavFeatures.NO_GLOBAL_SHORTCUT_LINKS.isEnabled(this.featureManager);
    }

    @Override
    public String getQueryStringFromComponents(Map<String, String[]> parameters) {
        return this.getQueryStringFromComponents(parameters, QUERY_PARAMETERS);
    }

    @Override
    public String getQueryStringFromComponents(Map<String, String[]> parameters, List<String> whiteList) {
        if (parameters == null) {
            return "";
        }
        UrlBuilder query = new UrlBuilder(false);
        for (String key : parameters.keySet()) {
            if (!whiteList.contains(key)) continue;
            this.addParameter(query, key, parameters.get(key));
        }
        return query.asUrlString();
    }

    private void addParameter(UrlBuilder urlBuilder, String key, String[] values) {
        for (String value : values) {
            urlBuilder.addParameter(key, value);
        }
    }

    @Override
    public Issue getIssue(Long issueId, ApplicationUser user) {
        IssueService.IssueResult issueResult;
        if (issueId != null && (issueResult = this.issueService.getIssue(user, issueId)).isValid()) {
            return issueResult.getIssue();
        }
        return null;
    }

    @Override
    public Issue getIssue(String issueKey, ApplicationUser user) {
        IssueService.IssueResult issueResult;
        if (issueKey != null && (issueResult = this.issueService.getIssue(user, issueKey)).isValid()) {
            return issueResult.getIssue();
        }
        return null;
    }

    @Override
    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.jiraAuthenticationContext.getLoggedInUser(), this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }

    @Override
    public String getSystemFiltersJson() {
        DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
        return marshaller.marshal(this.systemFilterService.getAllAsBeans());
    }

    @Override
    public SoyTemplateRenderer getSoyRenderer() {
        return this.soyTemplateRenderer;
    }
}

